/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.client.render.entity;

import aqario.fowlplay.client.render.entity.layer.BirdHeldItemLayer;
import aqario.fowlplay.client.render.entity.model.AdultBabyModelPair;
import aqario.fowlplay.client.render.entity.model.BabyPenguinModel;
import aqario.fowlplay.client.render.entity.model.PenguinModel;
import aqario.fowlplay.common.entity.PenguinEntity;
import aqario.fowlplay.core.FowlPlay;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.ChatFormatting;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;

public class PenguinRenderer
extends MobRenderer<PenguinEntity, PenguinModel> {
    private static final ResourceLocation TEXTURE = FowlPlay.id("textures/entity/penguin/penguin.png");
    private static final ResourceLocation BABY_TEXTURE = FowlPlay.id("textures/entity/penguin/penguin_baby.png");
    private final AdultBabyModelPair<PenguinModel> modelPair;

    public PenguinRenderer(EntityRendererProvider.Context context) {
        super(context, (EntityModel)new PenguinModel(context.bakeLayer(PenguinModel.MODEL_LAYER)), 0.3f);
        this.addLayer(new BirdHeldItemLayer(this, context.getItemInHandRenderer(), new Vec3(0.0, -0.145, -0.1475)));
        this.modelPair = PenguinRenderer.bakeModels(context);
    }

    private static AdultBabyModelPair<PenguinModel> bakeModels(EntityRendererProvider.Context context) {
        return new AdultBabyModelPair<PenguinModel>(new PenguinModel(context.bakeLayer(PenguinModel.MODEL_LAYER)), new BabyPenguinModel(context.bakeLayer(BabyPenguinModel.MODEL_LAYER)));
    }

    public void render(PenguinEntity penguin, float f, float g, PoseStack matrices, MultiBufferSource vertexConsumerProvider, int i) {
        this.model = (EntityModel)this.modelPair.getModel(penguin.isBaby());
        if (penguin.isBaby()) {
            matrices.scale(0.8f, 0.8f, 0.8f);
        }
        super.render((LivingEntity)penguin, f, g, matrices, vertexConsumerProvider, i);
    }

    public ResourceLocation getTextureLocation(PenguinEntity entity) {
        return entity.isBaby() ? BABY_TEXTURE : TEXTURE;
    }

    protected void scale(PenguinEntity penguin, PoseStack matrices, float amount) {
        super.scale((LivingEntity)penguin, matrices, amount);
        String name = ChatFormatting.stripFormatting((String)penguin.getName().getString());
        if (name.equalsIgnoreCase("rico")) {
            matrices.scale(1.1f, 1.0f, 1.0f);
        }
        if (name.equalsIgnoreCase("skipper")) {
            matrices.scale(1.25f, 0.9f, 1.0f);
        }
        if (name.equalsIgnoreCase("kowalski")) {
            matrices.scale(1.0f, 1.1f, 1.0f);
        }
        if (name.equalsIgnoreCase("private")) {
            matrices.scale(1.2f, 0.85f, 1.0f);
        }
    }
}

