/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.client.render.entity.model;

import aqario.fowlplay.client.render.entity.animation.GooseAnimations;
import aqario.fowlplay.client.render.entity.model.FlyingBirdModel;
import aqario.fowlplay.common.entity.GooseEntity;
import aqario.fowlplay.core.FowlPlay;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class GooseModel
extends FlyingBirdModel<GooseEntity> {
    public static final ModelLayerLocation MODEL_LAYER = new ModelLayerLocation(FowlPlay.id("goose"), "main");

    public GooseModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)19.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.5f, (float)0.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 23).addBox(-1.5f, -7.0f, -1.75f, 3.0f, 9.0f, 3.0f, new CubeDeformation(-0.001f)), PartPose.offset((float)0.0f, (float)-4.5f, (float)-3.5f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 16).addBox(-1.5f, -3.0f, -1.0f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-6.0f, (float)-1.75f));
        head.addOrReplaceChild("beak", CubeListBuilder.create().texOffs(22, 0).addBox(-1.0f, 0.0f, -2.5f, 2.0f, 1.0f, 3.0f, new CubeDeformation(-0.001f)).texOffs(0, 3).addBox(-1.0f, -0.75f, -2.5f, 2.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)-1.0f));
        PartDefinition torso = body.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 0).addBox(-3.0f, -6.0f, -6.5f, 6.0f, 6.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.5f, (float)2.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        torso.addOrReplaceChild("lower", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-2.0f, (float)-3.0f, (float)3.5f, (float)0.0873f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(0, 25).addBox(-2.0f, -1.0f, -1.0f, 3.0f, 6.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)2.5f, (float)-5.5f, (float)-0.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 25).mirror().addBox(-1.0f, -1.0f, -1.0f, 3.0f, 6.0f, 12.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-2.5f, (float)-5.5f, (float)-0.5f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        PartDefinition left_wing_open = body.addOrReplaceChild("left_wing_open", CubeListBuilder.create().texOffs(23, 0).addBox(-1.0f, -0.1f, -1.0f, 11.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)3.0f, (float)-6.5f, (float)-2.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        left_wing_open.addOrReplaceChild("left_wing_outer", CubeListBuilder.create().texOffs(24, 10).addBox(0.0f, 0.0f, 0.0f, 11.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)10.0f, (float)-0.1f, (float)-1.0f));
        PartDefinition right_wing_open = body.addOrReplaceChild("right_wing_open", CubeListBuilder.create().texOffs(23, 0).mirror().addBox(-10.0f, -0.1f, -1.0f, 11.0f, 1.0f, 9.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-3.0f, (float)-6.5f, (float)-2.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        right_wing_open.addOrReplaceChild("right_wing_outer", CubeListBuilder.create().texOffs(24, 10).mirror().addBox(-11.0f, 0.0f, 0.0f, 11.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-10.0f, (float)-0.1f, (float)-1.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(18, 25).addBox(-2.5f, -1.5f, 0.0f, 5.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(18, 18).addBox(-2.5f, -1.5f, 2.0f, 5.0f, 5.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(32, 18).addBox(-2.0f, -1.0f, 2.0f, 4.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(40, 18).addBox(-1.0f, -1.003f, 3.75f, 2.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-3.5f, (float)6.0f, (float)-0.0436f, (float)0.0f, (float)0.0f));
        tail.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(40, 18).addBox(-1.0f, -0.001f, -1.0f, 2.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.5f, (float)-1.0f, (float)4.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        tail.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(40, 18).addBox(-1.0f, -0.002f, -1.0f, 2.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-1.0f, (float)4.5f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        tail.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(40, 18).mirror().addBox(-1.0f, -0.002f, -1.0f, 2.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.5f, (float)-1.0f, (float)4.5f, (float)0.0f, (float)0.2618f, (float)0.0f));
        tail.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(40, 18).mirror().addBox(-1.0f, -0.001f, -1.0f, 2.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)1.5f, (float)-1.0f, (float)4.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -1.0f, 0.0f, 1.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(-1, 0).mirror().addBox(-1.5f, 4.0f, -3.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)2.25f, (float)1.0f, (float)2.5f));
        root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -1.0f, 0.0f, 1.0f, 5.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(-1, 0).addBox(-1.5f, 4.0f, -3.0f, 3.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)-2.25f, (float)1.0f, (float)2.5f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    @Override
    protected void setAnimations(GooseEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float partialTick) {
        if (!entity.isFlying() && !entity.isInWaterOrBubble()) {
            this.animateWalk(GooseAnimations.WALKING, limbSwing, limbSwingAmount, 3.0f, 3.0f);
        }
        this.animate(entity.standingState, GooseAnimations.STANDING, ageInTicks);
        this.animate(entity.swimmingState, GooseAnimations.SWIMMING, ageInTicks);
        this.animate(entity.glidingState, GooseAnimations.GLIDING, ageInTicks);
        this.animate(entity.flappingState, GooseAnimations.FLAPPING, ageInTicks);
    }
}

