/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.client.render.entity.model;

import aqario.fowlplay.client.render.entity.animation.RavenAnimations;
import aqario.fowlplay.client.render.entity.model.FlyingBirdModel;
import aqario.fowlplay.common.entity.RavenEntity;
import aqario.fowlplay.core.FowlPlay;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class RavenModel
extends FlyingBirdModel<RavenEntity> {
    public static final ModelLayerLocation MODEL_LAYER = new ModelLayerLocation(FowlPlay.id("raven"), "main");

    public RavenModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition root = modelPartData.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)19.0f, (float)0.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)1.5f, (float)0.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 18).addBox(-1.0f, -5.0f, -1.0f, 2.0f, 5.0f, 3.0f, new CubeDeformation(-0.001f)), PartPose.offset((float)0.0f, (float)-2.5f, (float)-2.5f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 12).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-4.0f, (float)0.0f));
        head.addOrReplaceChild("throat", CubeListBuilder.create().texOffs(22, 2).addBox(0.0f, 0.0f, -1.5f, 0.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.5f, (float)-1.0f));
        head.addOrReplaceChild("beak", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -0.5f, -2.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(0, 4).addBox(-0.5f, 0.0f, -2.5f, 1.0f, 1.0f, 3.0f, new CubeDeformation(-0.001f)), PartPose.offset((float)0.0f, (float)-1.5f, (float)-1.0f));
        PartDefinition torso = body.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 0).addBox(-2.0f, -3.0f, -6.5f, 4.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.5f, (float)2.5f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        torso.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(16, 8).addBox(0.0f, -2.0f, -3.0f, 0.0f, 6.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.25f, (float)-2.5f, (float)0.7854f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(0, 14).addBox(-1.0f, -1.0f, -1.0f, 2.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)-4.5f, (float)-0.5f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(0, 14).mirror().addBox(-1.0f, -1.0f, -1.0f, 2.0f, 4.0f, 12.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.5f, (float)-4.5f, (float)-0.5f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition left_wing_open = body.addOrReplaceChild("left_wing_open", CubeListBuilder.create().texOffs(24, 0).addBox(-1.0f, -0.1f, -1.0f, 9.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)-5.0f, (float)-1.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        left_wing_open.addOrReplaceChild("left_wing_outer", CubeListBuilder.create().texOffs(16, 9).addBox(0.0f, 0.0f, 0.0f, 10.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offset((float)8.0f, (float)-0.1f, (float)-1.0f));
        PartDefinition right_wing_open = body.addOrReplaceChild("right_wing_open", CubeListBuilder.create().texOffs(24, 0).mirror().addBox(-8.0f, -0.1f, -1.0f, 9.0f, 1.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.5f, (float)-5.0f, (float)-1.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        right_wing_open.addOrReplaceChild("right_wing_outer", CubeListBuilder.create().texOffs(16, 9).mirror().addBox(-10.0f, 0.0f, 0.0f, 10.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-8.0f, (float)-0.1f, (float)-1.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(16, 0).addBox(-1.5f, -1.0f, 1.0f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).texOffs(21, 0).addBox(-1.0f, -1.003f, 3.5f, 2.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.75f, (float)3.5f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        tail.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(22, 0).addBox(-1.0f, -0.001f, 0.0f, 2.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-1.0f, (float)2.0f, (float)0.0f, (float)-0.6109f, (float)0.0f));
        tail.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(21, 0).addBox(-1.0f, -0.002f, 0.0f, 2.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)-1.0f, (float)2.5f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        tail.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(21, 0).mirror().addBox(-1.0f, -0.002f, 0.0f, 2.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.5f, (float)-1.0f, (float)2.5f, (float)0.0f, (float)0.2618f, (float)0.0f));
        tail.addOrReplaceChild("cube_r5", CubeListBuilder.create().texOffs(22, 0).mirror().addBox(-1.0f, -0.001f, 0.0f, 2.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.5f, (float)-1.0f, (float)2.0f, (float)0.0f, (float)0.6109f, (float)0.0f));
        PartDefinition left_leg = root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(16, 4).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.25f, (float)1.0f, (float)2.5f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        left_leg.addOrReplaceChild("cube_r6", CubeListBuilder.create().texOffs(16, 4).mirror().addBox(0.5f, 0.0f, -2.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.5f, (float)4.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(16, 4).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 4.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.25f, (float)1.0f, (float)2.5f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        right_leg.addOrReplaceChild("cube_r7", CubeListBuilder.create().texOffs(16, 4).addBox(-0.5f, 0.0f, -2.0f, 2.0f, 0.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.5f, (float)4.0f, (float)0.0f, (float)0.1745f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)64, (int)64);
    }

    @Override
    protected void setAnimations(RavenEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float partialTick) {
        if (entity.isFlying()) {
            this.animateWalk(RavenAnimations.FLAPPING, limbSwing, limbSwingAmount, 1.5f, 1.5f);
        } else if (!entity.isInWaterOrBubble()) {
            this.animateWalk(RavenAnimations.WALKING, limbSwing, limbSwingAmount, 2.5f, 4.0f);
        }
        this.animate(entity.standingState, RavenAnimations.STANDING, ageInTicks);
        this.animate(entity.swimmingState, RavenAnimations.SWIMMING, ageInTicks);
        this.animate(entity.glidingState, RavenAnimations.GLIDING, ageInTicks);
    }

    @Override
    protected boolean shouldRenderWings(RavenEntity entity) {
        return super.shouldRenderWings(entity) || entity.isInWaterOrBubble();
    }
}

