/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain.behaviour;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetItemWalkTarget;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetWalkTargetAwayFrom;
import aqario.fowlplay.common.util.Birds;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.InvalidateMemory;

public class CustomBehaviours {
    public static <E extends BirdEntity> ExtendedBehaviour<E> setNearestFoodWalkTarget() {
        return new SetItemWalkTarget().radius(32).speed(1.4f);
    }

    public static <E extends BirdEntity> ExtendedBehaviour<E> setAvoidEntityWalkTarget() {
        return new SetWalkTargetAwayFrom(MemoryModuleType.AVOID_TARGET, Entity::position).speed(1.4f);
    }

    public static <E extends FlyingBirdEntity> ExtendedBehaviour<E> idleIfNotFlying() {
        return new Idle().noTimeout().startCondition(entity -> !entity.isFlying() && !Birds.isPerched(entity)).stopIf(entity -> entity.isFlying() || Birds.isPerched(entity));
    }

    public static <E extends FlyingBirdEntity> ExtendedBehaviour<E> idleIfPerched() {
        return new Idle().noTimeout().startCondition(Birds::isPerched).stopIf(Predicate.not(Birds::isPerched));
    }

    public static <E extends BirdEntity> ExtendedBehaviour<E> idleIfInWater() {
        return new Idle().noTimeout().startCondition(Entity::isInWaterOrBubble).stopIf(Predicate.not(Entity::isInWaterOrBubble));
    }

    public static <E extends BirdEntity> ExtendedBehaviour<E> forgetUnderwaterAttackTarget() {
        return new InvalidateMemory(MemoryModuleType.ATTACK_TARGET).invalidateIf((entity, target) -> entity.isInWaterOrBubble() && target.isUnderWater() && target.position().y < entity.position().y);
    }
}

