/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.navigation;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.ai.navigation.ExtendedRandomPos;
import aqario.fowlplay.common.util.CylindricalRadius;
import aqario.fowlplay.common.util.TargetingUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class BirdRandomPos {
    @Nullable
    public static Vec3 getWater(BirdEntity entity, CylindricalRadius range) {
        BlockPos pos = TargetingUtil.tryFindWater((PathfinderMob)entity, range, ExtendedRandomPos.generatePreferFar(entity.getRandom(), range.horizontal(), range.vertical()));
        return TargetingUtil.validatePos((PathfinderMob)entity, pos, range);
    }

    @Nullable
    public static Vec3 getNonAir(BirdEntity entity, CylindricalRadius range) {
        BlockPos pos = TargetingUtil.tryFindNonAir((PathfinderMob)entity, range, ExtendedRandomPos.generatePreferFar(entity.getRandom(), range.horizontal(), range.vertical()));
        return TargetingUtil.validatePos((PathfinderMob)entity, pos, range);
    }

    @Nullable
    public static Vec3 getGround(BirdEntity entity, CylindricalRadius range) {
        BlockPos pos = TargetingUtil.tryFindGround((PathfinderMob)entity, range, ExtendedRandomPos.generatePreferFar(entity.getRandom(), range.horizontal(), range.vertical()));
        return TargetingUtil.validatePos((PathfinderMob)entity, pos, range);
    }

    @Nullable
    public static Vec3 getPerch(BirdEntity entity, CylindricalRadius range) {
        BlockPos pos = TargetingUtil.tryFindPerch((PathfinderMob)entity, range, ExtendedRandomPos.generatePreferNear(entity.getRandom(), range.horizontal(), range.vertical()));
        return TargetingUtil.validatePos((PathfinderMob)entity, pos, range);
    }

    @Nullable
    public static Vec3 getAir(FlyingBirdEntity entity, CylindricalRadius range) {
        Vec3 direction = entity.getViewVector(1.0f);
        double angle = 15.0;
        BlockPos pos = TargetingUtil.tryFindAir(entity, range, ExtendedRandomPos.generateWithinAnglePreferFar(entity.getRandom(), range.horizontal(), range.vertical(), 0, direction, Math.toRadians(15.0)));
        return TargetingUtil.validatePos((PathfinderMob)entity, pos, range);
    }
}

