/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.navigation;

import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.util.Birds;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.pathfinder.FlyNodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.navigation.ExtendedNavigator;
import org.jetbrains.annotations.Nullable;

public class FlightNavigation
extends GroundPathNavigation
implements ExtendedNavigator {
    private static final int NODE_DISTANCE = 2;
    private static final float NODE_REACH_RADIUS = 1.5f;
    private final FlyingBirdEntity bird;

    public FlightNavigation(FlyingBirdEntity bird, Level world) {
        super((Mob)bird, world);
        this.bird = bird;
    }

    public Mob getMob() {
        return this.bird;
    }

    @Nullable
    public Path getPath() {
        return super.getPath();
    }

    protected PathFinder createPathFinder(int maxVisitedNodes) {
        this.nodeEvaluator = new FlyNodeEvaluator();
        this.nodeEvaluator.setCanPassDoors(true);
        return this.createSmoothPathFinder(this.nodeEvaluator, maxVisitedNodes);
    }

    @Nullable
    public Path patchPath(@Nullable Path path) {
        Path newPath = super.patchPath(path);
        if (newPath == null) {
            return null;
        }
        Path.DebugData debugNodeInfo = path.debugData();
        if (debugNodeInfo != null) {
            newPath.setDebug(debugNodeInfo.openSet(), debugNodeInfo.closedSet(), debugNodeInfo.targetNodes());
        }
        return newPath;
    }

    public boolean moveTo(double x, double y, double z, double speed) {
        this.bird.getMoveControl().setWantedPosition(x, y, z, speed);
        return true;
    }

    public boolean moveTo(Entity entity, double speed) {
        this.bird.getMoveControl().setWantedPosition(entity.getX(), entity.getY(), entity.getZ(), speed);
        return true;
    }

    protected boolean canMoveDirectly(Vec3 origin, Vec3 target) {
        return FlightNavigation.isClearForMovementBetween((Mob)this.bird, (Vec3)origin, (Vec3)target, (boolean)true);
    }

    protected boolean canUpdatePath() {
        return this.canFloat() && this.bird.isInLiquid() || !this.bird.isPassenger();
    }

    protected Vec3 getTempMobPos() {
        return this.getMob().position();
    }

    protected double getGroundY(Vec3 pos) {
        return pos.y;
    }

    public Path createPath(BlockPos target, int distance) {
        return this.createPath((Set)ImmutableSet.of((Object)target), 16, false, distance, 64.0f);
    }

    public void tick() {
        ++this.tick;
        if (this.hasDelayedRecomputation) {
            this.recomputePath();
        }
        if (!this.isDone()) {
            if (this.canUpdatePath()) {
                this.followThePath();
            } else if (this.path != null && !this.path.isDone()) {
                Vec3 pos = this.getTempMobPos();
                Vec3 nodePos = this.path.getNextEntityPos((Entity)this.bird);
                if (pos.y > nodePos.y && !this.bird.onGround() && Mth.floor((double)pos.x) == Mth.floor((double)nodePos.x) && Mth.floor((double)pos.z) == Mth.floor((double)nodePos.z)) {
                    this.path.advance();
                }
            }
            if (this.path != null && this.path.isDone() && this.getTargetPos() != null && this.bird.position().closerThan((Position)this.getTargetPos().getBottomCenter(), 2.0) && Birds.shouldLandAtDestination(this.bird, this.getTargetPos())) {
                this.bird.stopFlying();
            }
            DebugPackets.sendPathFindingPacket((Level)this.level, (Mob)this.getMob(), (Path)this.getPath(), (float)0.1f);
            if (!this.isDone()) {
                Vec3 vec3d = this.path.getNextEntityPos((Entity)this.bird);
                this.bird.getMoveControl().setWantedPosition(vec3d.x, vec3d.y, vec3d.z, this.speedModifier);
            }
        }
    }

    public Vec3 getEntityPosAtNode(int nodeIndex) {
        return Vec3.atBottomCenterOf((Vec3i)this.getPath().getNodePos(nodeIndex));
    }

    protected void followThePath() {
        Vec3 pos = this.getTempMobPos();
        int shortcutNodeIndex = this.getClosestVerticalTraversal(Mth.floor((double)pos.y));
        float f = this.maxDistanceToWaypoint = this.bird.getBbWidth() > 0.75f ? this.bird.getBbWidth() / 2.0f : 0.75f - this.bird.getBbWidth() / 2.0f;
        if (!this.attemptShortcut(shortcutNodeIndex, pos) && this.isCloseToNextNode(1.5f)) {
            int nextNodeIndex = this.path.getNextNodeIndex() + 2;
            if (this.path.getNextNodeIndex() < this.path.getNodeCount() - 1 && nextNodeIndex >= this.path.getNodeCount()) {
                this.path.setNextNodeIndex(this.path.getNodeCount() - 1);
            } else {
                this.path.setNextNodeIndex(nextNodeIndex);
            }
        }
        this.doStuckDetection(pos);
    }

    public boolean isCloseToNextNode(float distance) {
        Vec3 nextNodePos = this.getEntityPosAtNode(this.getPath().getNextNodeIndex());
        if (this.path.getNextNodeIndex() + 1 >= this.path.getNodeCount() && Birds.shouldLandAtDestination(this.bird, this.getTargetPos())) {
            return this.getTempMobPos().closerThan((Position)nextNodePos, 0.5);
        }
        return this.getTempMobPos().closerThan((Position)nextNodePos, (double)distance);
    }

    protected int getClosestVerticalTraversal(int safeSurfaceHeight) {
        int nodesLength = this.path.getNodeCount();
        for (int nodeIndex = this.path.getNextNodeIndex(); nodeIndex < nodesLength; ++nodeIndex) {
            if (this.path.getNode((int)nodeIndex).y == safeSurfaceHeight) continue;
            return nodeIndex;
        }
        return nodesLength;
    }

    public float getMaxDistanceToWaypoint() {
        return 1.5f;
    }

    public boolean isStableDestination(BlockPos pos) {
        return true;
    }
}

