/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.world.gen;

import aqario.fowlplay.common.config.FowlPlayConfig;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.SparrowEntity;
import aqario.fowlplay.core.FowlPlayEntityTypes;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;

public class SparrowSpawner
implements CustomSpawner {
    private static final int SPAWN_COOLDOWN = 2400;
    private static final int MAX_SPARROWS = 12;
    private int ticksUntilNextSpawn;

    public int tick(ServerLevel world, boolean spawnMonsters, boolean spawnAnimals) {
        if (!spawnAnimals || !world.getGameRules().getBoolean(GameRules.RULE_DOMOBSPAWNING) || FowlPlayConfig.getInstance().sparrowSpawnWeight <= 0) {
            return 0;
        }
        --this.ticksUntilNextSpawn;
        if (this.ticksUntilNextSpawn > 0) {
            return 0;
        }
        this.ticksUntilNextSpawn = 2400;
        ServerPlayer player = world.getRandomPlayer();
        if (player == null) {
            return 0;
        }
        RandomSource random = world.random;
        int x = (8 + random.nextInt(24)) * (random.nextBoolean() ? -1 : 1);
        int z = (8 + random.nextInt(24)) * (random.nextBoolean() ? -1 : 1);
        BlockPos pos = player.blockPosition().offset(x, 0, z);
        if (!world.hasChunksAt(pos.getX() - 10, pos.getZ() - 10, pos.getX() + 10, pos.getZ() + 10)) {
            return 0;
        }
        if (world.isCloseToVillage(pos, 2)) {
            return this.spawnNearPoi(world, pos);
        }
        return 0;
    }

    private int spawnNearPoi(ServerLevel world, BlockPos pos) {
        List nearbySparrows;
        if (world.getPoiManager().getCountInRange(holder -> holder.is(PoiTypes.HOME), pos, 48, PoiManager.Occupancy.IS_OCCUPIED) > 4L && (nearbySparrows = world.getEntitiesOfClass(SparrowEntity.class, new AABB(pos).inflate(48.0, 8.0, 48.0))).size() < 12 && FlyingBirdEntity.canSpawnPasserines(FowlPlayEntityTypes.SPARROW.get(), (LevelAccessor)world, MobSpawnType.NATURAL, pos, world.getRandom())) {
            return this.spawn(pos, world);
        }
        return 0;
    }

    private int spawn(BlockPos pos, ServerLevel world) {
        SparrowEntity sparrow = (SparrowEntity)FowlPlayEntityTypes.SPARROW.get().create((Level)world);
        if (sparrow == null) {
            return 0;
        }
        sparrow.finalizeSpawn((ServerLevelAccessor)world, world.getCurrentDifficultyAt(pos), MobSpawnType.NATURAL, null);
        sparrow.moveTo(pos, 0.0f, 0.0f);
        world.addFreshEntityWithPassengers((Entity)sparrow);
        return 1;
    }
}

