/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.core;

import aqario.fowlplay.common.config.FowlPlayConfig;
import aqario.fowlplay.common.entity.BlueJayEntity;
import aqario.fowlplay.common.entity.CardinalEntity;
import aqario.fowlplay.common.entity.ChickadeeEntity;
import aqario.fowlplay.common.entity.CrowEntity;
import aqario.fowlplay.common.entity.CustomMobCategory;
import aqario.fowlplay.common.entity.DuckEntity;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.GooseEntity;
import aqario.fowlplay.common.entity.GullEntity;
import aqario.fowlplay.common.entity.HawkEntity;
import aqario.fowlplay.common.entity.PenguinEntity;
import aqario.fowlplay.common.entity.PigeonEntity;
import aqario.fowlplay.common.entity.RavenEntity;
import aqario.fowlplay.common.entity.RobinEntity;
import aqario.fowlplay.common.entity.ScarecrowEntity;
import aqario.fowlplay.common.entity.SparrowEntity;
import aqario.fowlplay.common.util.EntityTypeBuilder;
import aqario.fowlplay.common.world.gen.CustomSpawnPlacementTypes;
import aqario.fowlplay.core.platform.PlatformHelper;
import aqario.fowlplay.core.tags.FowlPlayBiomeTags;
import dev.architectury.registry.level.biome.BiomeModifications;
import java.util.function.Supplier;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public final class FowlPlayEntityTypes {
    public static final Supplier<EntityType<BlueJayEntity>> BLUE_JAY = FowlPlayEntityTypes.register("blue_jay", EntityTypeBuilder.of(BlueJayEntity::new, CustomMobCategory.AMBIENT_BIRDS.mobCategory).attributes(FlyingBirdEntity::createFlyingBirdAttributes).spawnRestriction(CustomSpawnPlacementTypes.GROUND, Heightmap.Types.MOTION_BLOCKING, FlyingBirdEntity::canSpawnPasserines).sized(0.4f, 0.55f).eyeHeight(0.475f));
    public static final Supplier<EntityType<CardinalEntity>> CARDINAL = FowlPlayEntityTypes.register("cardinal", EntityTypeBuilder.of(CardinalEntity::new, CustomMobCategory.AMBIENT_BIRDS.mobCategory).attributes(FlyingBirdEntity::createFlyingBirdAttributes).spawnRestriction(CustomSpawnPlacementTypes.GROUND, Heightmap.Types.MOTION_BLOCKING, FlyingBirdEntity::canSpawnPasserines).sized(0.4f, 0.55f).eyeHeight(0.475f));
    public static final Supplier<EntityType<ChickadeeEntity>> CHICKADEE = FowlPlayEntityTypes.register("chickadee", EntityTypeBuilder.of(ChickadeeEntity::new, CustomMobCategory.AMBIENT_BIRDS.mobCategory).attributes(FlyingBirdEntity::createFlyingBirdAttributes).spawnRestriction(CustomSpawnPlacementTypes.GROUND, Heightmap.Types.MOTION_BLOCKING, FlyingBirdEntity::canSpawnPasserines).sized(0.3f, 0.45f).eyeHeight(0.4f));
    public static final Supplier<EntityType<CrowEntity>> CROW = FowlPlayEntityTypes.register("crow", EntityTypeBuilder.of(CrowEntity::new, CustomMobCategory.AMBIENT_BIRDS.mobCategory).attributes(CrowEntity::createCrowAttributes).spawnRestriction(CustomSpawnPlacementTypes.GROUND, Heightmap.Types.MOTION_BLOCKING, FlyingBirdEntity::canSpawnPasserines).sized(0.5f, 0.6f).eyeHeight(0.55f));
    public static final Supplier<EntityType<DuckEntity>> DUCK = FowlPlayEntityTypes.register("duck", EntityTypeBuilder.of(DuckEntity::new, CustomMobCategory.BIRDS.mobCategory).attributes(DuckEntity::createDuckAttributes).spawnRestriction(CustomSpawnPlacementTypes.AQUATIC, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, FlyingBirdEntity::canSpawnWaterfowl).sized(0.6f, 0.8f).eyeHeight(0.7f));
    public static final Supplier<EntityType<GooseEntity>> GOOSE = FowlPlayEntityTypes.register("goose", EntityTypeBuilder.of(GooseEntity::new, CustomMobCategory.BIRDS.mobCategory).attributes(GooseEntity::createGooseAttributes).spawnRestriction(CustomSpawnPlacementTypes.AQUATIC, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, FlyingBirdEntity::canSpawnWaterfowl).sized(0.7f, 1.1f).eyeHeight(1.0f));
    public static final Supplier<EntityType<GullEntity>> GULL = FowlPlayEntityTypes.register("gull", EntityTypeBuilder.of(GullEntity::new, CustomMobCategory.BIRDS.mobCategory).attributes(GullEntity::createGullAttributes).spawnRestriction(CustomSpawnPlacementTypes.SEMIAQUATIC, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, FlyingBirdEntity::canSpawnShorebirds).sized(0.6f, 0.8f).eyeHeight(0.7f));
    public static final Supplier<EntityType<HawkEntity>> HAWK = FowlPlayEntityTypes.register("hawk", EntityTypeBuilder.of(HawkEntity::new, CustomMobCategory.BIRDS.mobCategory).attributes(HawkEntity::createHawkAttributes).spawnRestriction(CustomSpawnPlacementTypes.GROUND, Heightmap.Types.MOTION_BLOCKING, FlyingBirdEntity::canSpawnPasserines).sized(0.6f, 0.8f).eyeHeight(0.7f));
    public static final Supplier<EntityType<PenguinEntity>> PENGUIN = FowlPlayEntityTypes.register("penguin", EntityTypeBuilder.of(PenguinEntity::new, MobCategory.CREATURE).attributes(PenguinEntity::createPenguinAttributes).spawnRestriction(CustomSpawnPlacementTypes.SEMIAQUATIC, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, PenguinEntity::canSpawnPenguins).sized(0.5f, 1.4f).eyeHeight(1.35f).passengerAttachments(new Vec3(0.0, 0.75, -0.1)));
    public static final Supplier<EntityType<PigeonEntity>> PIGEON = FowlPlayEntityTypes.register("pigeon", EntityTypeBuilder.of(PigeonEntity::new, CustomMobCategory.BIRDS.mobCategory).attributes(PigeonEntity::createPigeonAttributes).spawnRestriction(CustomSpawnPlacementTypes.GROUND, Heightmap.Types.MOTION_BLOCKING, FlyingBirdEntity::canSpawnShorebirds).sized(0.5f, 0.6f).eyeHeight(0.5f));
    public static final Supplier<EntityType<RavenEntity>> RAVEN = FowlPlayEntityTypes.register("raven", EntityTypeBuilder.of(RavenEntity::new, CustomMobCategory.AMBIENT_BIRDS.mobCategory).attributes(RavenEntity::createRavenAttributes).spawnRestriction(CustomSpawnPlacementTypes.GROUND, Heightmap.Types.MOTION_BLOCKING, FlyingBirdEntity::canSpawnPasserines).sized(0.6f, 0.8f).eyeHeight(0.7f));
    public static final Supplier<EntityType<RobinEntity>> ROBIN = FowlPlayEntityTypes.register("robin", EntityTypeBuilder.of(RobinEntity::new, CustomMobCategory.AMBIENT_BIRDS.mobCategory).attributes(FlyingBirdEntity::createFlyingBirdAttributes).spawnRestriction(CustomSpawnPlacementTypes.GROUND, Heightmap.Types.MOTION_BLOCKING, FlyingBirdEntity::canSpawnPasserines).sized(0.4f, 0.55f).eyeHeight(0.475f));
    public static final Supplier<EntityType<SparrowEntity>> SPARROW = FowlPlayEntityTypes.register("sparrow", EntityTypeBuilder.of(SparrowEntity::new, CustomMobCategory.AMBIENT_BIRDS.mobCategory).attributes(FlyingBirdEntity::createFlyingBirdAttributes).spawnRestriction(CustomSpawnPlacementTypes.GROUND, Heightmap.Types.MOTION_BLOCKING, FlyingBirdEntity::canSpawnPasserines).sized(0.3f, 0.45f).eyeHeight(0.4f));
    public static final Supplier<EntityType<ScarecrowEntity>> SCARECROW = FowlPlayEntityTypes.register("scarecrow", EntityTypeBuilder.of(ScarecrowEntity::new, MobCategory.MISC).attributes(ScarecrowEntity::createScarecrowAttributes).sized(0.6f, 2.0f).eyeHeight(1.72f));

    private static <T extends Entity> Supplier<EntityType<T>> register(String id, EntityTypeBuilder<T> builder) {
        return PlatformHelper.registerEntityType(id, () -> builder.build(id));
    }

    public static void init() {
        FowlPlayEntityTypes.addSpawn(FowlPlayBiomeTags.SPAWNS_BLUE_JAYS, CustomMobCategory.AMBIENT_BIRDS.mobCategory, BLUE_JAY, FowlPlayConfig.getInstance().blueJaySpawnWeight, FowlPlayConfig.getInstance().blueJayMinGroupSize, FowlPlayConfig.getInstance().blueJayMaxGroupSize);
        FowlPlayEntityTypes.addSpawn(FowlPlayBiomeTags.SPAWNS_CARDINALS, CustomMobCategory.AMBIENT_BIRDS.mobCategory, CARDINAL, FowlPlayConfig.getInstance().cardinalSpawnWeight, FowlPlayConfig.getInstance().cardinalMinGroupSize, FowlPlayConfig.getInstance().cardinalMaxGroupSize);
        FowlPlayEntityTypes.addSpawn(FowlPlayBiomeTags.SPAWNS_CHICKADEES, CustomMobCategory.AMBIENT_BIRDS.mobCategory, CHICKADEE, FowlPlayConfig.getInstance().chickadeeSpawnWeight, FowlPlayConfig.getInstance().chickadeeMinGroupSize, FowlPlayConfig.getInstance().chickadeeMaxGroupSize);
        FowlPlayEntityTypes.addSpawn(FowlPlayBiomeTags.SPAWNS_CROWS, CustomMobCategory.AMBIENT_BIRDS.mobCategory, CROW, FowlPlayConfig.getInstance().crowSpawnWeight, FowlPlayConfig.getInstance().crowMinGroupSize, FowlPlayConfig.getInstance().crowMaxGroupSize);
        FowlPlayEntityTypes.addSpawn(FowlPlayBiomeTags.SPAWNS_DUCKS, CustomMobCategory.BIRDS.mobCategory, DUCK, FowlPlayConfig.getInstance().duckSpawnWeight, FowlPlayConfig.getInstance().duckMinGroupSize, FowlPlayConfig.getInstance().duckMaxGroupSize);
        FowlPlayEntityTypes.addSpawn(FowlPlayBiomeTags.SPAWNS_GEESE, CustomMobCategory.BIRDS.mobCategory, GOOSE, FowlPlayConfig.getInstance().gooseSpawnWeight, FowlPlayConfig.getInstance().gooseMinGroupSize, FowlPlayConfig.getInstance().gooseMaxGroupSize);
        FowlPlayEntityTypes.addSpawn(FowlPlayBiomeTags.SPAWNS_GULLS, CustomMobCategory.BIRDS.mobCategory, GULL, FowlPlayConfig.getInstance().gullSpawnWeight, FowlPlayConfig.getInstance().gullMinGroupSize, FowlPlayConfig.getInstance().gullMaxGroupSize);
        FowlPlayEntityTypes.addSpawn(FowlPlayBiomeTags.SPAWNS_HAWKS, CustomMobCategory.BIRDS.mobCategory, HAWK, FowlPlayConfig.getInstance().hawkSpawnWeight, FowlPlayConfig.getInstance().hawkMinGroupSize, FowlPlayConfig.getInstance().hawkMaxGroupSize);
        FowlPlayEntityTypes.addSpawn(FowlPlayBiomeTags.SPAWNS_PENGUINS, MobCategory.CREATURE, PENGUIN, FowlPlayConfig.getInstance().penguinSpawnWeight, FowlPlayConfig.getInstance().penguinMinGroupSize, FowlPlayConfig.getInstance().penguinMaxGroupSize);
        FowlPlayEntityTypes.addSpawn(FowlPlayBiomeTags.SPAWNS_PIGEONS, CustomMobCategory.BIRDS.mobCategory, PIGEON, FowlPlayConfig.getInstance().pigeonSpawnWeight, FowlPlayConfig.getInstance().pigeonMinGroupSize, FowlPlayConfig.getInstance().pigeonMaxGroupSize);
        FowlPlayEntityTypes.addSpawn(FowlPlayBiomeTags.SPAWNS_RAVENS, CustomMobCategory.AMBIENT_BIRDS.mobCategory, RAVEN, FowlPlayConfig.getInstance().ravenSpawnWeight, FowlPlayConfig.getInstance().ravenMinGroupSize, FowlPlayConfig.getInstance().ravenMaxGroupSize);
        FowlPlayEntityTypes.addSpawn(FowlPlayBiomeTags.SPAWNS_ROBINS, CustomMobCategory.AMBIENT_BIRDS.mobCategory, ROBIN, FowlPlayConfig.getInstance().robinSpawnWeight, FowlPlayConfig.getInstance().robinMinGroupSize, FowlPlayConfig.getInstance().robinMaxGroupSize);
        FowlPlayEntityTypes.addSpawn(FowlPlayBiomeTags.SPAWNS_SPARROWS, CustomMobCategory.AMBIENT_BIRDS.mobCategory, SPARROW, FowlPlayConfig.getInstance().sparrowSpawnWeight, FowlPlayConfig.getInstance().sparrowMinGroupSize, FowlPlayConfig.getInstance().sparrowMaxGroupSize);
        FowlPlayEntityTypes.setSpawnCost(FowlPlayBiomeTags.SPAWNS_DUCKS, DUCK, 0.8, 0.1);
        FowlPlayEntityTypes.setSpawnCost(FowlPlayBiomeTags.SPAWNS_GULLS, GULL, 1.0, 0.07);
    }

    public static <T extends Entity> void addSpawn(TagKey<Biome> tag, MobCategory spawnGroup, Supplier<EntityType<T>> type, int weight, int minGroupSize, int maxGroupSize) {
        BiomeModifications.addProperties(context -> context.hasTag(tag), (context, mutable) -> mutable.getSpawnProperties().addSpawn(spawnGroup, new MobSpawnSettings.SpawnerData((EntityType)type.get(), weight, minGroupSize, maxGroupSize)));
    }

    public static <T extends Entity> void setSpawnCost(TagKey<Biome> tag, Supplier<EntityType<T>> type, double gravityLimit, double mass) {
        BiomeModifications.addProperties(context -> context.hasTag(tag), (context, mutable) -> mutable.getSpawnProperties().setSpawnCost((EntityType)type.get(), new MobSpawnSettings.MobSpawnCost(gravityLimit, mass)));
    }
}

