/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.inventory;

import com.jaquadro.minecraft.storagedrawers.components.item.DrawerCountData;
import com.jaquadro.minecraft.storagedrawers.core.ModDataComponents;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class ItemStackHelper {
    public static Item getTrueItem(@NotNull ItemStack stack) {
        return stack.getItem();
    }

    @NotNull
    public static ItemStack getItemPrototype(@NotNull ItemStack stack) {
        return stack.copy();
    }

    public static int getMaxStackSize(ItemStack stack) {
        return (Integer)stack.getOrDefault(DataComponents.MAX_STACK_SIZE, (Object)stack.getItem().getDefaultMaxStackSize());
    }

    @NotNull
    public static ItemStack encodeItemStack(@NotNull ItemStack stack) {
        if (!stack.isEmpty()) {
            return stack;
        }
        ItemStack proto = ItemStackHelper.getItemPrototype(stack);
        if (proto.isEmpty()) {
            return stack;
        }
        proto.set((DataComponentType)ModDataComponents.DRAWER_COUNT.get(), (Object)new DrawerCountData(stack.getCount()));
        return proto;
    }

    public static ItemStack encodeItemStack(@NotNull ItemStack proto, int count) {
        if (!proto.isEmpty() && count > 0 && count < 128) {
            ItemStack stack = proto.copy();
            stack.setCount(count);
            return stack;
        }
        if (count == 0 || count >= 128) {
            ItemStack stack = proto.copy();
            stack.set((DataComponentType)ModDataComponents.DRAWER_COUNT.get(), (Object)new DrawerCountData(count));
            return stack;
        }
        return proto.copy();
    }

    public static ItemStack decodeItemStack(@NotNull ItemStack stack) {
        int count = ItemStackHelper.decodedCount(stack);
        ItemStack decode = ItemStackHelper.stripDecoding(stack);
        decode.setCount(count);
        return decode;
    }

    public static ItemStack decodeItemStackPrototype(@NotNull ItemStack stack) {
        ItemStack decode = ItemStackHelper.stripDecoding(stack);
        decode.setCount(1);
        return decode;
    }

    public static int decodedCount(@NotNull ItemStack stack) {
        DrawerCountData data = (DrawerCountData)stack.get((DataComponentType)ModDataComponents.DRAWER_COUNT.get());
        if (data != null) {
            return data.count();
        }
        return stack.getCount();
    }

    public static ItemStack stripDecoding(@NotNull ItemStack stack) {
        ItemStack decode = stack.copy();
        decode.remove((DataComponentType)ModDataComponents.DRAWER_COUNT.get());
        return decode;
    }

    public static boolean isStackEncoded(@NotNull ItemStack stack) {
        DrawerCountData data = (DrawerCountData)stack.get((DataComponentType)ModDataComponents.DRAWER_COUNT.get());
        return data != null;
    }
}

