/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.api.storage.EmptyDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import com.jaquadro.minecraft.storagedrawers.capabilities.Capabilities;
import com.jaquadro.minecraft.storagedrawers.util.ComponentUtil;
import com.texelsaurus.minecraft.chameleon.util.WorldUtils;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ItemKey
extends Item {
    public ItemKey(Item.Properties properties) {
        super(properties.attributes(ItemKey.createAttributes()));
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 2.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public boolean canAttackBlock(@NotNull BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, @NotNull Player player) {
        return !player.isCreative();
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag flag) {
        super.appendHoverText(stack, context, tooltip, flag);
        ComponentUtil.appendSplitDescription(tooltip, this);
        if (!this.isEnabled()) {
            tooltip.add((Component)Component.translatable((String)"itemConfig.storagedrawers.disabled_tool").withStyle(ChatFormatting.YELLOW));
        }
    }

    @NotNull
    public Component getDescription() {
        return this.isEnabled() ? Component.translatable((String)(this.getDescriptionId() + ".desc")) : Component.empty();
    }

    @NotNull
    public InteractionResult useOn(UseOnContext context) {
        if (!this.isEnabled()) {
            return InteractionResult.PASS;
        }
        BlockEntity blockEntity = WorldUtils.getBlockEntity((BlockGetter)context.getLevel(), context.getClickedPos(), BlockEntity.class);
        if (blockEntity == null) {
            return InteractionResult.PASS;
        }
        IDrawerAttributes attrs = Capabilities.DRAWER_ATTRIBUTES.getCapability(blockEntity.getLevel(), blockEntity.getBlockPos());
        if (attrs == null) {
            attrs = EmptyDrawerAttributes.EMPTY;
        }
        if (!(attrs instanceof IDrawerAttributesModifiable)) {
            return InteractionResult.PASS;
        }
        this.handleDrawerAttributes((IDrawerAttributesModifiable)attrs);
        if (context.getPlayer() != null) {
            context.getPlayer().getCooldowns().addCooldown((Item)this, 5);
        }
        return InteractionResult.SUCCESS;
    }

    protected void handleDrawerAttributes(IDrawerAttributesModifiable attrs) {
    }

    public boolean isEnabled() {
        return true;
    }
}

