/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.common.ai.pathing;

import net.caffeinemc.mods.lithium.common.ai.pathing.BlockStatePathingCache;
import net.caffeinemc.mods.lithium.common.block.BlockCountingSection;
import net.caffeinemc.mods.lithium.common.block.BlockStateFlags;
import net.caffeinemc.mods.lithium.common.util.Pos;
import net.caffeinemc.mods.lithium.common.world.ChunkView;
import net.caffeinemc.mods.lithium.common.world.WorldHelper;
import net.caffeinemc.mods.lithium.mixin.ai.pathing.PathfindingContextAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.level.pathfinder.PathfindingContext;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public abstract class PathNodeCache {
    private static boolean isChunkSectionDangerousNeighbor(LevelChunkSection section) {
        return section.getStates().maybeHas(state -> PathNodeCache.getNeighborPathNodeType((BlockBehaviour.BlockStateBase)state) != PathType.OPEN);
    }

    public static PathType getPathNodeType(BlockState state) {
        return ((BlockStatePathingCache)state).lithium$getPathNodeType();
    }

    public static PathType getNeighborPathNodeType(BlockBehaviour.BlockStateBase state) {
        return ((BlockStatePathingCache)state).lithium$getNeighborPathNodeType();
    }

    public static boolean isSectionSafeAsNeighbor(LevelChunkSection section) {
        if (section.hasOnlyAir()) {
            return true;
        }
        if (BlockStateFlags.ENABLED) {
            return !((BlockCountingSection)section).lithium$mayContainAny(BlockStateFlags.PATH_NOT_OPEN);
        }
        return !PathNodeCache.isChunkSectionDangerousNeighbor(section);
    }

    public static PathType getNodeTypeFromNeighbors(PathfindingContext context, int x, int y, int z, PathType fallback) {
        CollisionGetter world = context.level();
        LevelChunkSection section = null;
        if (world instanceof ChunkView) {
            ChunkView chunkView = (ChunkView)world;
            if (WorldHelper.areNeighborsWithinSameChunkSection(x, y, z)) {
                ChunkAccess chunk;
                if (!world.isOutsideBuildHeight(y) && (chunk = chunkView.lithium$getLoadedChunk(Pos.ChunkCoord.fromBlockCoord(x), Pos.ChunkCoord.fromBlockCoord(z))) != null) {
                    section = chunk.getSections()[Pos.SectionYIndex.fromBlockCoord((LevelHeightAccessor)world, y)];
                }
                if (section == null || PathNodeCache.isSectionSafeAsNeighbor(section)) {
                    return fallback;
                }
            }
        }
        int xStart = x - 1;
        int yStart = y - 1;
        int zStart = z - 1;
        int xEnd = x + 1;
        int yEnd = y + 1;
        int zEnd = z + 1;
        for (int adjX = xStart; adjX <= xEnd; ++adjX) {
            for (int adjY = yStart; adjY <= yEnd; ++adjY) {
                for (int adjZ = zStart; adjZ <= zEnd; ++adjZ) {
                    BlockState state;
                    if (adjX == x && adjZ == z) continue;
                    if (section != null) {
                        state = section.getBlockState(adjX & 0xF, adjY & 0xF, adjZ & 0xF);
                    } else {
                        BlockPos.MutableBlockPos pos = ((PathfindingContextAccessor)context).getLastNodePos().set(adjX, adjY, adjZ);
                        state = world.getBlockState((BlockPos)pos);
                    }
                    if (state.isAir()) continue;
                    PathType neighborType = PathNodeCache.getNeighborPathNodeType((BlockBehaviour.BlockStateBase)state);
                    if (neighborType == null && (neighborType = WalkNodeEvaluator.checkNeighbourBlocks((PathfindingContext)context, (int)(adjX + 1), (int)(adjY + 1), (int)(adjZ + 1), null)) == null) {
                        neighborType = PathType.OPEN;
                    }
                    if (neighborType == PathType.OPEN) continue;
                    return neighborType;
                }
            }
        }
        return fallback;
    }
}

