/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core;

import DistantHorizons.libraries.electronwill.nightconfig.core.Config;
import DistantHorizons.libraries.jpountz.lz4.LZ4FrameOutputStream;
import com.seibel.distanthorizons.api.DhApi;
import com.seibel.distanthorizons.core.api.external.methods.config.DhApiConfig;
import com.seibel.distanthorizons.core.api.external.methods.data.DhApiTerrainDataRepo;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.render.DhApiRenderProxy;
import com.seibel.distanthorizons.core.render.renderer.generic.GenericRenderObjectFactory;
import com.seibel.distanthorizons.core.sql.DatabaseUpdater;
import com.seibel.distanthorizons.core.world.DhApiWorldProxy;
import com.seibel.distanthorizons.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import dh_sqlite.SQLiteConnection;
import dh_sqlite.SQLiteJDBCLoader;
import dh_sqlite.core.NativeDB;
import dhcomgithubluben.zstd.Zstd;
import dhcomgithubluben.zstd.ZstdOutputStream;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;
import org.tukaani.xz.XZOutputStream;

public class Initializer {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final IMinecraftClientWrapper MC_CLIENT = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);

    public static void init() {
        LOGGER.info("Running library validation...", new Object[0]);
        try {
            Class<LZ4FrameOutputStream> lz4Compressor = LZ4FrameOutputStream.class;
            Class<ZstdOutputStream> zstdCompressor = ZstdOutputStream.class;
            byte[] testCompressByteArray = new byte[1024];
            for (int i = 0; i < testCompressByteArray.length; ++i) {
                testCompressByteArray[i] = (byte)(i % 126);
            }
            byte[] compressedBytes = Zstd.compress(testCompressByteArray);
            Zstd.decompress(compressedBytes);
            Class<XZOutputStream> lzmaCompressor = XZOutputStream.class;
            Class<Config> config = Config.class;
            Class<LongArrayList> oldFastUtil = LongArrayList.class;
            Class<SQLiteConnection> sqliteJava = SQLiteConnection.class;
            Class<NativeDB> sqliteNative = NativeDB.class;
            boolean sqliteLoaded = SQLiteJDBCLoader.initialize();
            if (!sqliteLoaded) {
                throw new RuntimeException("Failed to load SQLite native library. Hopefully SQLite logged a reason for this failure.");
            }
        }
        catch (Throwable e) {
            MC_CLIENT.crashMinecraft("Distant Horizons critical setup error: One or more libraries are either in-accessible, corrupted, or overwritten by another mod. Error: [" + e.getMessage() + "].", e);
        }
        try {
            int scriptCount = DatabaseUpdater.getAutoUpdateScriptCount();
            if (scriptCount == 0) {
                throw new NullPointerException("No auto update scripts found, but no error thrown. This might mean the script list file is corrupted or empty.");
            }
        }
        catch (Exception e) {
            MC_CLIENT.crashMinecraft("Critical programmer error: Can't read SQL Scripts resource folder is either missing or malformed. Error: [" + e.getMessage() + "].", e);
        }
        DhApi.Delayed.configs = DhApiConfig.INSTANCE;
        DhApi.Delayed.terrainRepo = DhApiTerrainDataRepo.INSTANCE;
        DhApi.Delayed.worldProxy = DhApiWorldProxy.INSTANCE;
        DhApi.Delayed.renderProxy = DhApiRenderProxy.INSTANCE;
        DhApi.Delayed.customRenderObjectFactory = GenericRenderObjectFactory.INSTANCE;
        DhApi.Delayed.wrapperFactory = SingletonInjector.INSTANCE.get(IWrapperFactory.class);
        if (DhApi.Delayed.wrapperFactory == null) {
            LOGGER.error("Programmer Error: No [" + IWrapperFactory.class.getSimpleName() + "] assigned to the DhApi.", new Object[0]);
        }
        boolean g1GcInUse = false;
        StringBuilder garbageCollectorNames = new StringBuilder();
        List<GarbageCollectorMXBean> gcMxBeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcMxBean : gcMxBeans) {
            if (!garbageCollectorNames.toString().isEmpty()) {
                garbageCollectorNames.append(", ");
            }
            garbageCollectorNames.append(gcMxBean.getName());
            if (!gcMxBean.getName().toLowerCase().contains("g1 ")) continue;
            g1GcInUse = true;
        }
        LOGGER.info("Garbage collectors: [" + garbageCollectorNames + "]", new Object[0]);
        if (g1GcInUse && Config.Common.Logging.Warning.logGarbageCollectorWarning.get().booleanValue()) {
            LOGGER.warn("Distant Horizons: G1 Garbage collector detected. \nThis garbage collector can cause FPS stuttering. \nIt's recommended to use a concurrent garbage collector \nlike ZGC (Java 21+) or Shenandoah (Java 8 through 17) for a smoother experience. \n", new Object[0]);
        }
    }
}

