/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.file.fullDatafile.V2;

import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.file.fullDatafile.V2.FullDataSourceProviderV2;
import com.seibel.distanthorizons.core.file.fullDatafile.V2.FullDataUpdaterV2;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.render.renderer.IDebugRenderable;
import com.seibel.distanthorizons.core.util.ThreadUtil;
import com.seibel.distanthorizons.core.util.threading.PriorityTaskPicker;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongListIterator;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.Nullable;

public class FullDataUpdatePropagatorV2
implements IDebugRenderable,
AutoCloseable {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final IMinecraftClientWrapper MC_CLIENT = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    protected static final int PROPAGATE_QUEUE_THREAD_DELAY_IN_MS = 250;
    public static final int NUMBER_OF_PARENT_UPDATE_TASKS_PER_THREAD = 5;
    private final Set<Long> updatingPosSet = ConcurrentHashMap.newKeySet();
    @Nullable
    public final ThreadPoolExecutor updateQueueProcessor;
    private final AtomicBoolean isShutdownRef = new AtomicBoolean(false);
    private final String levelId;
    private final FullDataSourceProviderV2 provider;
    private final FullDataUpdaterV2 dataUpdater;

    public static int getMaxPropagateTaskCount() {
        return 5 * Config.Common.MultiThreading.numberOfThreads.get();
    }

    public FullDataUpdatePropagatorV2(FullDataSourceProviderV2 provider, FullDataUpdaterV2 dataUpdater, String levelId) {
        this.provider = provider;
        this.dataUpdater = dataUpdater;
        this.levelId = levelId;
        this.updateQueueProcessor = ThreadUtil.makeSingleThreadPool("Update Propagate Queue [" + this.levelId + "]");
        this.updateQueueProcessor.execute(this::runUpdateQueue);
    }

    private void runUpdateQueue() {
        while (!Thread.interrupted()) {
            try {
                Thread.sleep(250L);
                PriorityTaskPicker.Executor executor = ThreadPoolUtil.getUpdatePropagatorExecutor();
                if (executor == null || executor.isTerminated()) continue;
                DhBlockPos targetBlockPos = DhBlockPos.ZERO;
                if (MC_CLIENT != null && MC_CLIENT.playerExists()) {
                    targetBlockPos = MC_CLIENT.getPlayerBlockPos();
                }
                this.runParentUpdates(executor, targetBlockPos);
                if (!Config.Common.LodBuilding.Experimental.upsampleLowerDetailLodsToFillHoles.get().booleanValue()) continue;
                this.runChildUpdates(executor, targetBlockPos);
            }
            catch (InterruptedException ignored) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.error("Unexpected error in the parent update queue thread. Error: " + e.getMessage(), e);
            }
        }
    }

    private void runParentUpdates(PriorityTaskPicker.Executor executor, DhBlockPos targetBlockPos) {
        int maxUpdateTaskCount = FullDataUpdatePropagatorV2.getMaxPropagateTaskCount();
        if (executor.getQueueSize() < maxUpdateTaskCount && this.updatingPosSet.size() < maxUpdateTaskCount) {
            LongArrayList parentUpdatePosList = this.provider.repo.getPositionsToUpdate(targetBlockPos.getX(), targetBlockPos.getZ(), maxUpdateTaskCount);
            HashMap<Long, HashSet> updatePosByParentPos = new HashMap<Long, HashSet>();
            for (Long pos : parentUpdatePosList) {
                updatePosByParentPos.compute(DhSectionPos.getParentPos(pos), (parentPos, updatePosSet) -> {
                    if (updatePosSet == null) {
                        updatePosSet = new HashSet<Long>();
                    }
                    updatePosSet.add(pos);
                    return updatePosSet;
                });
            }
            for (Long parentUpdatePos : updatePosByParentPos.keySet()) {
                if (this.updatingPosSet.size() > maxUpdateTaskCount || executor.getQueueSize() > maxUpdateTaskCount || !this.updatingPosSet.add(parentUpdatePos)) break;
                try {
                    executor.execute(() -> {
                        block22: {
                            ReentrantLock parentWriteLock = this.dataUpdater.updateLockProvider.getLock(parentUpdatePos);
                            boolean parentLocked = false;
                            try {
                                if (!parentWriteLock.tryLock()) break block22;
                                parentLocked = true;
                                this.dataUpdater.lockedPosSet.add(parentUpdatePos);
                                try (FullDataSourceV2 parentDataSource = this.provider.get(parentUpdatePos);){
                                    if (parentDataSource == null) break block22;
                                    for (Long childPos : (HashSet)updatePosByParentPos.get(parentUpdatePos)) {
                                        ReentrantLock childReadLock = this.dataUpdater.updateLockProvider.getLock(childPos);
                                        try {
                                            childReadLock.lock();
                                            this.dataUpdater.lockedPosSet.add(childPos);
                                            FullDataSourceV2 childDataSource = this.provider.get(childPos);
                                            try {
                                                if (childDataSource == null) continue;
                                                parentDataSource.updateFromDataSource(childDataSource);
                                            }
                                            finally {
                                                if (childDataSource == null) continue;
                                                childDataSource.close();
                                            }
                                        }
                                        catch (Exception e) {
                                            LOGGER.error("Unexpected in parent update propagation for parent pos: [" + DhSectionPos.toString(parentUpdatePos) + "], child pos: [" + DhSectionPos.toString(parentUpdatePos) + "], Error: [" + e.getMessage() + "].", e);
                                        }
                                        finally {
                                            this.provider.repo.setApplyToParent(childPos, false);
                                            childReadLock.unlock();
                                            this.dataUpdater.lockedPosSet.remove(childPos);
                                        }
                                    }
                                    if (DhSectionPos.getDetailLevel(parentUpdatePos) < 15) {
                                        parentDataSource.applyToParent = true;
                                    }
                                    this.dataUpdater.updateDataSource(parentDataSource);
                                }
                            }
                            finally {
                                if (parentLocked) {
                                    parentWriteLock.unlock();
                                    this.dataUpdater.lockedPosSet.remove(parentUpdatePos);
                                }
                                this.updatingPosSet.remove(parentUpdatePos);
                            }
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                }
                catch (Exception e) {
                    this.updatingPosSet.remove(parentUpdatePos);
                    throw e;
                }
            }
        }
    }

    private void runChildUpdates(PriorityTaskPicker.Executor executor, DhBlockPos targetBlockPos) {
        int maxUpdateTaskCount = FullDataUpdatePropagatorV2.getMaxPropagateTaskCount();
        if (executor.getQueueSize() < maxUpdateTaskCount && this.updatingPosSet.size() < maxUpdateTaskCount) {
            LongArrayList childUpdatePosList = this.provider.repo.getChildPositionsToUpdate(targetBlockPos.getX(), targetBlockPos.getZ(), maxUpdateTaskCount);
            LongListIterator longListIterator = childUpdatePosList.iterator();
            while (longListIterator.hasNext()) {
                long parentUpdatePos = (Long)longListIterator.next();
                if (this.updatingPosSet.size() > maxUpdateTaskCount || executor.getQueueSize() > maxUpdateTaskCount) break;
                if (!this.updatingPosSet.add(parentUpdatePos)) continue;
                try {
                    executor.execute(() -> {
                        block23: {
                            ReentrantLock parentReadLock = this.dataUpdater.updateLockProvider.getLock(parentUpdatePos);
                            boolean parentLocked = false;
                            try {
                                if (!parentReadLock.tryLock()) break block23;
                                parentLocked = true;
                                this.dataUpdater.lockedPosSet.add(parentUpdatePos);
                                try (FullDataSourceV2 parentDataSource = this.provider.get(parentUpdatePos);){
                                    if (parentDataSource == null) break block23;
                                    for (int i = 0; i < 4; ++i) {
                                        long childPos = DhSectionPos.getChildByIndex(parentUpdatePos, i);
                                        ReentrantLock childWriteLock = this.dataUpdater.updateLockProvider.getLock(childPos);
                                        try {
                                            childWriteLock.lock();
                                            this.dataUpdater.lockedPosSet.add(childPos);
                                            try (FullDataSourceV2 childDataSource = this.provider.get(childPos);){
                                                if (childDataSource == null) continue;
                                                childDataSource.updateFromDataSource(parentDataSource);
                                                if (DhSectionPos.getDetailLevel(childPos) != 6) {
                                                    childDataSource.applyToChildren = true;
                                                }
                                                this.dataUpdater.updateDataSource(childDataSource);
                                                continue;
                                            }
                                        }
                                        catch (Exception e) {
                                            LOGGER.error("Unexpected in child update propagation for parent pos: [" + DhSectionPos.toString(parentUpdatePos) + "], child pos: [" + DhSectionPos.toString(parentUpdatePos) + "], Error: [" + e.getMessage() + "].", e);
                                            continue;
                                        }
                                        finally {
                                            this.provider.repo.setApplyToChild(parentUpdatePos, false);
                                            childWriteLock.unlock();
                                            this.dataUpdater.lockedPosSet.remove(childPos);
                                        }
                                    }
                                }
                            }
                            finally {
                                if (parentLocked) {
                                    parentReadLock.unlock();
                                    this.dataUpdater.lockedPosSet.remove(parentUpdatePos);
                                }
                                this.updatingPosSet.remove(parentUpdatePos);
                            }
                        }
                    });
                }
                catch (RejectedExecutionException rejectedExecutionException) {
                }
                catch (Exception e) {
                    this.updatingPosSet.remove(parentUpdatePos);
                    throw e;
                }
            }
        }
    }

    @Override
    public void debugRender(DebugRenderer renderer) {
        this.updatingPosSet.forEach(pos -> renderer.renderBox(new DebugRenderer.Box((long)pos, -32.0f, 80.0f, 0.2f, Color.MAGENTA)));
    }

    @Override
    public void close() {
        if (this.updateQueueProcessor != null) {
            this.updateQueueProcessor.shutdownNow();
        }
    }
}

