/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.file.fullDatafile.V2;

import com.seibel.distanthorizons.api.enums.config.EDhApiDataCompressionMode;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.file.fullDatafile.IDataSourceUpdateListenerFunc;
import com.seibel.distanthorizons.core.file.fullDatafile.V2.FullDataSourceProviderV2;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhSectionPos;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.render.renderer.IDebugRenderable;
import com.seibel.distanthorizons.core.sql.dto.FullDataSourceV2DTO;
import com.seibel.distanthorizons.core.util.threading.PositionalLockProvider;
import com.seibel.distanthorizons.core.util.threading.PriorityTaskPicker;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;

public class FullDataUpdaterV2
implements IDebugRenderable,
AutoCloseable {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    protected final PositionalLockProvider updateLockProvider = new PositionalLockProvider();
    public final Set<Long> lockedPosSet = ConcurrentHashMap.newKeySet();
    private final ConcurrentHashMap<Long, AtomicInteger> queuedUpdateCountsByPos = new ConcurrentHashMap();
    public final ArrayList<IDataSourceUpdateListenerFunc<FullDataSourceV2>> dateSourceUpdateListeners = new ArrayList();
    private final String levelId;
    private final AtomicBoolean isShutdownRef = new AtomicBoolean(false);
    private final FullDataSourceProviderV2 provider;

    public FullDataUpdaterV2(FullDataSourceProviderV2 provider, String levelId) {
        this.provider = provider;
        this.levelId = levelId;
    }

    public CompletableFuture<Void> updateDataSourceAsync(@NotNull FullDataSourceV2 inputDataSource) {
        if (this.isShutdownRef.get()) {
            return CompletableFuture.completedFuture(null);
        }
        PriorityTaskPicker.Executor executor = ThreadPoolUtil.getChunkToLodBuilderExecutor();
        if (executor == null || executor.isTerminated()) {
            return CompletableFuture.completedFuture(null);
        }
        try {
            this.markUpdateStart(inputDataSource.getPos());
            return CompletableFuture.runAsync(() -> {
                try {
                    this.updateDataSource(inputDataSource);
                }
                catch (Exception e) {
                    LOGGER.error("Unexpected error in async data source update at pos: [" + DhSectionPos.toString(inputDataSource.getPos()) + "], error: [" + e.getMessage() + "].", e);
                }
                finally {
                    this.markUpdateEnd(inputDataSource.getPos());
                }
            }, executor);
        }
        catch (RejectedExecutionException ignore) {
            this.markUpdateEnd(inputDataSource.getPos());
            return CompletableFuture.completedFuture(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDataSource(@NotNull FullDataSourceV2 inputData) {
        block23: {
            if (this.isShutdownRef.get()) {
                return;
            }
            long updatePos = inputData.getPos();
            ReentrantLock updateLock = this.updateLockProvider.getLock(updatePos);
            try {
                updateLock.lock();
                this.lockedPosSet.add(updatePos);
                try (FullDataSourceV2 recipientDataSource = this.provider.get(updatePos);){
                    boolean dataModified;
                    if (recipientDataSource == null || !(dataModified = recipientDataSource.updateFromDataSource(inputData))) break block23;
                    try (FullDataSourceV2DTO dto = this.createDtoFromDataSource(recipientDataSource);){
                        if (dto != null) {
                            this.provider.repo.save(dto);
                        }
                    }
                    ArrayList<IDataSourceUpdateListenerFunc<FullDataSourceV2>> arrayList = this.dateSourceUpdateListeners;
                    synchronized (arrayList) {
                        for (IDataSourceUpdateListenerFunc<FullDataSourceV2> listener : this.dateSourceUpdateListeners) {
                            if (listener == null) continue;
                            listener.OnDataSourceUpdated(recipientDataSource);
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Error updating pos [" + DhSectionPos.toString(updatePos) + "], error: " + e.getMessage(), e);
            }
            finally {
                updateLock.unlock();
                this.lockedPosSet.remove(updatePos);
            }
        }
    }

    private FullDataSourceV2DTO createDtoFromDataSource(FullDataSourceV2 dataSource) {
        try {
            EDhApiDataCompressionMode compressionModeEnum = Config.Common.LodBuilding.dataCompression.get();
            return FullDataSourceV2DTO.CreateFromDataSource(dataSource, compressionModeEnum);
        }
        catch (IOException e) {
            LOGGER.warn("Unable to create DTO, error: [" + e.getMessage() + "].", e);
            return null;
        }
    }

    private void markUpdateStart(long dataSourcePos) {
        this.queuedUpdateCountsByPos.compute(dataSourcePos, (pos, atomicCount) -> {
            if (atomicCount == null) {
                atomicCount = new AtomicInteger(0);
            }
            atomicCount.incrementAndGet();
            return atomicCount;
        });
    }

    private void markUpdateEnd(long dataSourcePos) {
        this.queuedUpdateCountsByPos.compute(dataSourcePos, (pos, atomicCount) -> {
            if (atomicCount != null && atomicCount.decrementAndGet() <= 0) {
                atomicCount = null;
            }
            return atomicCount;
        });
    }

    @Override
    public void debugRender(DebugRenderer renderer) {
        this.lockedPosSet.forEach(pos -> renderer.renderBox(new DebugRenderer.Box((long)pos, -32.0f, 74.0f, 0.15f, Color.PINK)));
        this.queuedUpdateCountsByPos.forEach((pos, updateCountRef) -> renderer.renderBox(new DebugRenderer.Box((long)pos, -32.0f, 80.0f + (float)updateCountRef.get() * 16.0f, 0.2f, Color.WHITE)));
    }

    @Override
    public void close() {
        this.isShutdownRef.set(true);
    }
}

