/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.chunk;

import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.ChunkLightStorage;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.IMutableBlockPosWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.util.ArrayList;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.block.BiomeWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.block.BlockStateWrapper;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.misc.MutableBlockPosWrapper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.QuartPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.Heightmap;

public class ChunkWrapper
implements IChunkWrapper {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final ThreadLocal<BlockPos.MutableBlockPos> MUTABLE_BLOCK_POS_REF = ThreadLocal.withInitial(() -> new BlockPos.MutableBlockPos());
    private static final ThreadLocal<MutableBlockPosWrapper> MUTABLE_BLOCK_POS_WRAPPER_REF = ThreadLocal.withInitial(() -> new MutableBlockPosWrapper());
    private final ChunkAccess chunk;
    private final DhChunkPos chunkPos;
    private final ILevelWrapper wrappedLevel;
    private boolean isDhBlockLightCorrect = false;
    private boolean isDhSkyLightCorrect = false;
    private ChunkLightStorage blockLightStorage;
    private ChunkLightStorage skyLightStorage;
    private ArrayList<DhBlockPos> blockLightPosList = null;
    private int minNonEmptyHeight = Integer.MIN_VALUE;
    private int maxNonEmptyHeight = Integer.MAX_VALUE;
    private int[][] solidHeightMap = null;
    private int[][] lightBlockingHeightMap = null;

    public ChunkWrapper(ChunkAccess chunk, ILevelWrapper wrappedLevel) {
        this(chunk, wrappedLevel, true);
    }

    public ChunkWrapper(ChunkAccess chunk, ILevelWrapper wrappedLevel, boolean recreateHeightmaps) {
        this.chunk = chunk;
        this.wrappedLevel = wrappedLevel;
        this.chunkPos = new DhChunkPos(chunk.getPos().x, chunk.getPos().z);
        if (recreateHeightmaps) {
            this.createDhHeightMaps();
        }
    }

    @Override
    public int getHeight() {
        return ChunkWrapper.getHeight(this.chunk);
    }

    public static int getHeight(ChunkAccess chunk) {
        return chunk.getHeight();
    }

    @Override
    public int getInclusiveMinBuildHeight() {
        return ChunkWrapper.getInclusiveMinBuildHeight(this.chunk);
    }

    public static int getInclusiveMinBuildHeight(ChunkAccess chunk) {
        return chunk.getMinBuildHeight();
    }

    @Override
    public int getExclusiveMaxBuildHeight() {
        return ChunkWrapper.getExclusiveMaxBuildHeight(this.chunk);
    }

    public static int getExclusiveMaxBuildHeight(ChunkAccess chunk) {
        return chunk.getMaxBuildHeight();
    }

    @Override
    public int getMinNonEmptyHeight() {
        if (this.minNonEmptyHeight != Integer.MIN_VALUE) {
            return this.minNonEmptyHeight;
        }
        this.minNonEmptyHeight = this.getInclusiveMinBuildHeight();
        LevelChunkSection[] sections = this.chunk.getSections();
        for (int index = 0; index < sections.length; ++index) {
            if (sections[index] == null || ChunkWrapper.isChunkSectionEmpty(sections[index])) continue;
            this.minNonEmptyHeight = this.getChunkSectionMinHeight(index);
            break;
        }
        return this.minNonEmptyHeight;
    }

    @Override
    public int getMaxNonEmptyHeight() {
        if (this.maxNonEmptyHeight != Integer.MAX_VALUE) {
            return this.maxNonEmptyHeight;
        }
        this.maxNonEmptyHeight = this.getExclusiveMaxBuildHeight();
        LevelChunkSection[] sections = this.chunk.getSections();
        for (int index = sections.length - 1; index >= 0; --index) {
            this.maxNonEmptyHeight = this.getChunkSectionMinHeight(index) + 16;
            if (sections[index] != null && !ChunkWrapper.isChunkSectionEmpty(sections[index])) break;
        }
        return this.maxNonEmptyHeight;
    }

    private static boolean isChunkSectionEmpty(LevelChunkSection section) {
        return section.hasOnlyAir();
    }

    private int getChunkSectionMinHeight(int index) {
        return index * 16 + this.getInclusiveMinBuildHeight();
    }

    public void createDhHeightMaps() {
        this.minNonEmptyHeight = Integer.MIN_VALUE;
        this.maxNonEmptyHeight = Integer.MAX_VALUE;
        this.solidHeightMap = new int[16][16];
        this.lightBlockingHeightMap = new int[16][16];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int minInclusiveBuildHeight;
                int solidHeight = minInclusiveBuildHeight = this.getMinNonEmptyHeight();
                int lightBlockingHeight = minInclusiveBuildHeight;
                int y = this.getMaxNonEmptyHeight();
                IBlockStateWrapper block = this.getBlockState(x, y, z);
                while (y > minInclusiveBuildHeight && (solidHeight == minInclusiveBuildHeight || lightBlockingHeight == minInclusiveBuildHeight)) {
                    if (solidHeight == minInclusiveBuildHeight && block.isSolid()) {
                        solidHeight = y;
                    }
                    if (lightBlockingHeight == minInclusiveBuildHeight && block.getOpacity() != 0) {
                        lightBlockingHeight = y;
                    }
                    block = this.getBlockState(x, --y, z);
                }
                this.solidHeightMap[x][z] = solidHeight;
                this.lightBlockingHeightMap[x][z] = lightBlockingHeight;
            }
        }
    }

    @Override
    public int getSolidHeightMapValue(int xRel, int zRel) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(xRel, zRel);
        if (this.solidHeightMap == null) {
            return this.chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.WORLD_SURFACE).getFirstAvailable(xRel, zRel);
        }
        return this.solidHeightMap[xRel][zRel];
    }

    @Override
    public int getLightBlockingHeightMapValue(int xRel, int zRel) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(xRel, zRel);
        if (this.lightBlockingHeightMap == null) {
            return this.chunk.getOrCreateHeightmapUnprimed(Heightmap.Types.MOTION_BLOCKING).getFirstAvailable(xRel, zRel);
        }
        return this.lightBlockingHeightMap[xRel][zRel];
    }

    @Override
    public IBiomeWrapper getBiome(int relX, int relY, int relZ) {
        return BiomeWrapper.getBiomeWrapper((Holder<Biome>)this.chunk.getNoiseBiome(QuartPos.fromBlock((int)relX), QuartPos.fromBlock((int)relY), QuartPos.fromBlock((int)relZ)), this.wrappedLevel);
    }

    @Override
    public IBlockStateWrapper getBlockState(int relX, int relY, int relZ) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, relY, relZ);
        BlockPos.MutableBlockPos blockPos = MUTABLE_BLOCK_POS_REF.get();
        blockPos.setX(relX);
        blockPos.setY(relY);
        blockPos.setZ(relZ);
        return BlockStateWrapper.fromBlockState(this.chunk.getBlockState((BlockPos)blockPos), this.wrappedLevel);
    }

    @Override
    public IBlockStateWrapper getBlockState(int relX, int relY, int relZ, IMutableBlockPosWrapper mcBlockPos, IBlockStateWrapper guess) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, relY, relZ);
        BlockPos.MutableBlockPos pos = (BlockPos.MutableBlockPos)mcBlockPos.getWrappedMcObject();
        pos.setX(relX);
        pos.setY(relY);
        pos.setZ(relZ);
        return BlockStateWrapper.fromBlockState(this.chunk.getBlockState((BlockPos)pos), this.wrappedLevel, guess);
    }

    @Override
    public IMutableBlockPosWrapper getMutableBlockPosWrapper() {
        return MUTABLE_BLOCK_POS_WRAPPER_REF.get();
    }

    @Override
    public DhChunkPos getChunkPos() {
        return this.chunkPos;
    }

    public ChunkAccess getChunk() {
        return this.chunk;
    }

    public void trySetStatus(ChunkStatus status) {
        ChunkWrapper.trySetStatus(this.getChunk(), status);
    }

    public static void trySetStatus(ChunkAccess chunk, ChunkStatus status) {
        if (chunk instanceof ProtoChunk) {
            ((ProtoChunk)chunk).setPersistedStatus(status);
        }
    }

    public ChunkStatus getStatus() {
        return ChunkWrapper.getStatus(this.getChunk());
    }

    public static ChunkStatus getStatus(ChunkAccess chunk) {
        return chunk.getPersistedStatus();
    }

    @Override
    public int getMaxBlockX() {
        return this.chunk.getPos().getMaxBlockX();
    }

    @Override
    public int getMaxBlockZ() {
        return this.chunk.getPos().getMaxBlockZ();
    }

    @Override
    public int getMinBlockX() {
        return this.chunk.getPos().getMinBlockX();
    }

    @Override
    public int getMinBlockZ() {
        return this.chunk.getPos().getMinBlockZ();
    }

    @Override
    public void setIsDhSkyLightCorrect(boolean isDhLightCorrect) {
        this.isDhSkyLightCorrect = isDhLightCorrect;
    }

    @Override
    public void setIsDhBlockLightCorrect(boolean isDhLightCorrect) {
        this.isDhBlockLightCorrect = isDhLightCorrect;
    }

    @Override
    public boolean isDhBlockLightingCorrect() {
        return this.isDhBlockLightCorrect;
    }

    @Override
    public boolean isDhSkyLightCorrect() {
        return this.isDhSkyLightCorrect;
    }

    @Override
    public int getDhBlockLight(int relX, int y, int relZ) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, y, relZ);
        return this.getBlockLightStorage().get(relX, y, relZ);
    }

    @Override
    public void setDhBlockLight(int relX, int y, int relZ, int lightValue) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, y, relZ);
        this.getBlockLightStorage().set(relX, y, relZ, lightValue);
    }

    private ChunkLightStorage getBlockLightStorage() {
        if (this.blockLightStorage == null) {
            this.blockLightStorage = ChunkLightStorage.createBlockLightStorage(this);
        }
        return this.blockLightStorage;
    }

    public void setBlockLightStorage(ChunkLightStorage lightStorage) {
        this.blockLightStorage = lightStorage;
    }

    @Override
    public void clearDhBlockLighting() {
        this.getBlockLightStorage().clear();
    }

    @Override
    public int getDhSkyLight(int relX, int y, int relZ) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, y, relZ);
        return this.getSkyLightStorage().get(relX, y, relZ);
    }

    @Override
    public void setDhSkyLight(int relX, int y, int relZ, int lightValue) {
        this.throwIndexOutOfBoundsIfRelativePosOutsideChunkBounds(relX, y, relZ);
        this.getSkyLightStorage().set(relX, y, relZ, lightValue);
    }

    @Override
    public void clearDhSkyLighting() {
        this.getSkyLightStorage().clear();
    }

    private ChunkLightStorage getSkyLightStorage() {
        if (this.skyLightStorage == null) {
            this.skyLightStorage = ChunkLightStorage.createSkyLightStorage(this);
        }
        return this.skyLightStorage;
    }

    public void setSkyLightStorage(ChunkLightStorage lightStorage) {
        this.skyLightStorage = lightStorage;
    }

    @Override
    public synchronized ArrayList<DhBlockPos> getWorldBlockLightPosList() {
        if (this.blockLightPosList == null) {
            this.blockLightPosList = new ArrayList();
            this.chunk.findBlockLightSources((blockPos, blockState) -> {
                DhBlockPos pos = new DhBlockPos(blockPos.getX(), blockPos.getY(), blockPos.getZ());
                this.blockLightPosList.add(pos);
            });
        }
        return this.blockLightPosList;
    }

    @Override
    public String toString() {
        return this.chunk.getClass().getSimpleName() + String.valueOf(this.chunk.getPos());
    }
}

