/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.network;

import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.p3pp3rf1y.sophisticatedcore.SophisticatedCore;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;

public record SyncContainerStacksPayload(int windowId, int stateId, List<ItemStack> itemStacks, ItemStack carriedStack) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<SyncContainerStacksPayload> TYPE = new CustomPacketPayload.Type(SophisticatedCore.getRL("sync_container_stacks"));
    public static final StreamCodec<RegistryFriendlyByteBuf, SyncContainerStacksPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, SyncContainerStacksPayload::windowId, (StreamCodec)ByteBufCodecs.INT, SyncContainerStacksPayload::stateId, (StreamCodec)ItemStack.OPTIONAL_LIST_STREAM_CODEC, SyncContainerStacksPayload::itemStacks, (StreamCodec)ItemStack.OPTIONAL_STREAM_CODEC, SyncContainerStacksPayload::carriedStack, SyncContainerStacksPayload::new);

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handlePayload(SyncContainerStacksPayload payload, IPayloadContext context) {
        Player player = context.player();
        if (!(player.containerMenu instanceof StorageContainerMenuBase) || player.containerMenu.containerId != payload.windowId) {
            return;
        }
        player.containerMenu.initializeContents(payload.stateId, payload.itemStacks, payload.carriedStack);
    }
}

