/*
 * Decompiled with CFR 0.152.
 */
package journeymap.api.client.impl;

import com.google.common.collect.HashBasedTable;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import journeymap.api.client.impl.ClientEventManager;
import journeymap.api.client.impl.PluginWrapper;
import journeymap.api.v2.client.IClientAPI;
import journeymap.api.v2.client.IClientPlugin;
import journeymap.api.v2.client.display.Context;
import journeymap.api.v2.client.display.DisplayType;
import journeymap.api.v2.client.display.Displayable;
import journeymap.api.v2.client.display.Overlay;
import journeymap.api.v2.client.util.PluginHelper;
import journeymap.api.v2.client.util.UIState;
import journeymap.api.v2.common.waypoint.Waypoint;
import journeymap.api.v2.common.waypoint.WaypointGroup;
import journeymap.client.JourneymapClient;
import journeymap.client.feature.FeatureManager;
import journeymap.client.io.FileHandler;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.render.draw.OverlayDrawStep;
import journeymap.client.task.multi.ApiImageTask;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.minimap.MiniMap;
import journeymap.client.waypoint.ClientWaypointImpl;
import journeymap.common.Journeymap;
import journeymap.common.waypoint.WaypointGroupStore;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Strings;

@ParametersAreNonnullByDefault
public enum ClientAPI implements IClientAPI
{
    INSTANCE;

    private final Logger LOGGER = Journeymap.getLogger();
    private final List<OverlayDrawStep> lastDrawSteps = new ArrayList<OverlayDrawStep>();
    private HashMap<String, PluginWrapper> plugins = new HashMap();
    private ClientEventManager clientEventManager = new ClientEventManager(this.plugins.values());
    private boolean drawStepsUpdateNeeded = true;
    private Context.UI lastUi = null;
    private Context.MapType lastMapType = null;
    private ResourceKey<Level> lastDimension = Level.OVERWORLD;
    private File addonDataPath;
    private UIState lastUiState;

    private ClientAPI() {
        this.log("built with JourneyMap API 2.0.0-SNAPSHOT");
    }

    public UIState getUIState(Context.UI ui) {
        switch (ui) {
            case Minimap: {
                return MiniMap.uiState();
            }
            case Fullscreen: {
                return Fullscreen.uiState();
            }
        }
        return null;
    }

    @Nullable
    public File getDataPath(String modId) {
        if (this.addonDataPath == null || Minecraft.getInstance().level == null) {
            return null;
        }
        return new File(this.addonDataPath, modId);
    }

    public void refreshDataPathCache(boolean flush) {
        this.addonDataPath = flush ? null : FileHandler.getAddonDataPath(Minecraft.getInstance());
    }

    public List<? extends Waypoint> getAllWaypoints() {
        return new ArrayList<ClientWaypointImpl>(WaypointStore.getInstance().getAll());
    }

    public List<Waypoint> getAllWaypoints(ResourceKey<Level> dim) {
        return WaypointStore.getInstance().getAll().stream().filter(waypoint -> waypoint.getDimensions().contains(dim.location().toString())).collect(Collectors.toList());
    }

    @Nullable
    public Waypoint getWaypoint(String modId, String guid) {
        return this.getPlugin(modId).getWaypoint(guid);
    }

    public List<Waypoint> getWaypoints(String modId) {
        return this.getPlugin(modId).getWaypoints();
    }

    public void removeWaypoint(String modId, Waypoint waypoint) {
        this.getPlugin(modId).remove(waypoint);
    }

    public void addWaypoint(String modId, Waypoint waypoint) {
        this.getPlugin(modId).add(waypoint);
    }

    public void removeAllWaypoints(String modId) {
        this.getPlugin(modId).removeAllWaypoints();
    }

    public void addWaypointGroup(WaypointGroup waypointGroup) {
        WaypointGroupStore.getInstance().put(waypointGroup);
    }

    public WaypointGroup getWaypointGroup(String groupId) {
        return WaypointGroupStore.getInstance().get(groupId);
    }

    public WaypointGroup getWaypointGroupByName(String modid, String name) {
        return WaypointGroupStore.getInstance().getForMod(modid).stream().filter(group -> name.equalsIgnoreCase(group.getName())).findFirst().orElse(null);
    }

    public List<? extends WaypointGroup> getWaypointGroups(String modId) {
        return WaypointGroupStore.getInstance().getForMod(modId);
    }

    public List<? extends WaypointGroup> getAllWaypointGroups() {
        return WaypointGroupStore.getInstance().getAll();
    }

    public void removeWaypointGroup(WaypointGroup waypointGroup, boolean deleteWaypoints) {
        WaypointGroupStore.getInstance().remove(waypointGroup, deleteWaypoints);
    }

    public void removeWaypointGroups(String modId, boolean deleteWaypoints) {
        WaypointGroupStore.getInstance().removeAll(modId, deleteWaypoints);
    }

    public String getWorldId() {
        return JourneymapClient.getInstance().getCurrentWorldId();
    }

    public void toggleMinimap(boolean enable) {
        JourneymapClient.getInstance().getStateHandler().setMinimapEnabledApi(enable);
    }

    public boolean minimapEnabled() {
        return JourneymapClient.getInstance().getStateHandler().isMinimapEnabledApi();
    }

    public void show(Displayable displayable) {
        try {
            if (this.playerAccepts(displayable)) {
                this.getPlugin(displayable.getModId()).show(displayable);
                this.drawStepsUpdateNeeded = true;
            }
        }
        catch (Throwable t) {
            this.logError("Error showing displayable: " + String.valueOf(displayable), t);
        }
    }

    public void remove(Displayable displayable) {
        try {
            if (this.playerAccepts(displayable)) {
                this.getPlugin(displayable.getModId()).remove(displayable);
                this.drawStepsUpdateNeeded = true;
            }
        }
        catch (Throwable t) {
            this.logError("Error removing displayable: " + String.valueOf(displayable), t);
        }
    }

    public void removeAll(String modId, DisplayType displayType) {
        try {
            if (this.playerAccepts(modId, displayType)) {
                this.getPlugin(modId).removeAll(displayType);
                this.drawStepsUpdateNeeded = true;
            }
        }
        catch (Throwable t) {
            this.logError("Error removing all displayables: " + String.valueOf(displayType), t);
        }
    }

    public void removeAll(String modId) {
        try {
            for (DisplayType displayType : DisplayType.values()) {
                this.removeAll(modId, displayType);
                this.drawStepsUpdateNeeded = true;
            }
            this.getPlugin(modId).removeAllWaypoints();
        }
        catch (Throwable t) {
            this.logError("Error removing all displayables for mod: " + modId, t);
        }
    }

    public void purge() {
        try {
            this.drawStepsUpdateNeeded = true;
            this.lastDrawSteps.clear();
            this.plugins.clear();
            this.clientEventManager.purge();
        }
        catch (Throwable t) {
            this.logError("Error purging: " + String.valueOf(t), t);
        }
    }

    public boolean exists(Displayable displayable) {
        try {
            if (this.playerAccepts(displayable)) {
                return this.getPlugin(displayable.getModId()).exists(displayable);
            }
        }
        catch (Throwable t) {
            this.logError("Error checking exists: " + String.valueOf(displayable), t);
        }
        return false;
    }

    public boolean playerAccepts(String modId, DisplayType displayType) {
        return true;
    }

    public void requestMapTile(String modId, ResourceKey<Level> dimension, Context.MapType apiMapType, ChunkPos startChunk, ChunkPos endChunk, @Nullable Integer chunkY, int zoom, boolean showGrid, Consumer<NativeImage> callback) {
        boolean validModId;
        this.log("requestMapTile");
        boolean honorRequest = true;
        File worldDir = FileHandler.getJMWorldDir(Minecraft.getInstance());
        boolean bl = validModId = Objects.equals("jmitems", modId) || Objects.equals("skymap", modId);
        if (!validModId) {
            honorRequest = false;
            this.logError("requestMapTile not supported");
        } else if (worldDir == null || !worldDir.exists() || !worldDir.isDirectory()) {
            honorRequest = false;
            this.logError("world directory not found: " + String.valueOf(worldDir));
        }
        try {
            if (honorRequest) {
                JourneymapClient.getInstance().queueOneOff(new ApiImageTask(modId, dimension, apiMapType, startChunk, endChunk, chunkY, zoom, showGrid, callback));
            } else {
                Minecraft.getInstance().submit(() -> callback.accept(null));
            }
        }
        catch (Exception e) {
            callback.accept(null);
        }
    }

    private boolean playerAccepts(Displayable displayable) {
        return this.playerAccepts(displayable.getModId(), displayable.getDisplayType());
    }

    public ClientEventManager getClientEventManager() {
        return this.clientEventManager;
    }

    public void getDrawSteps(List<? super OverlayDrawStep> list, UIState uiState) {
        if (this.drawStepsUpdateNeeded) {
            this.lastDrawSteps.clear();
            for (PluginWrapper pluginWrapper : this.plugins.values()) {
                pluginWrapper.getDrawSteps(this.lastDrawSteps, uiState);
            }
            this.lastDrawSteps.sort(Comparator.comparingInt(DrawStep::getDisplayOrder));
            this.drawStepsUpdateNeeded = false;
        }
        if (uiState.ui != this.lastUi || !uiState.dimension.equals(this.lastDimension) || uiState.mapType != this.lastMapType) {
            this.drawStepsUpdateNeeded = true;
            this.lastUi = uiState.ui;
            this.lastUiState = uiState;
            this.lastDimension = uiState.dimension;
            this.lastMapType = uiState.mapType;
        }
        list.addAll(this.lastDrawSteps);
    }

    public void disableFeature(@Nullable ResourceKey<Level> dimension, Context.MapType mapType, boolean enable) {
        if (enable) {
            throw new UnsupportedOperationException("Enabling is currently unsupported.");
        }
        FeatureManager.getInstance().disableFeature(mapType, dimension);
    }

    private PluginWrapper getPlugin(String modId) {
        if (Strings.isEmpty((CharSequence)modId)) {
            throw new IllegalArgumentException("Invalid modId: " + modId);
        }
        PluginWrapper pluginWrapper = this.plugins.get(modId);
        if (pluginWrapper == null) {
            IClientPlugin plugin = (IClientPlugin)PluginHelper.INSTANCE.getPlugins().get(modId);
            if (plugin == null) {
                if (modId.equals("journeymap")) {
                    plugin = new IClientPlugin(this){

                        public void initialize(IClientAPI jmClientApi) {
                        }

                        public String getModId() {
                            return "journeymap";
                        }
                    };
                } else {
                    throw new IllegalArgumentException("No plugin found for modId: " + modId);
                }
            }
            pluginWrapper = new PluginWrapper(plugin);
            this.plugins.put(modId, pluginWrapper);
        }
        return pluginWrapper;
    }

    public boolean isDrawStepsUpdateNeeded() {
        return this.drawStepsUpdateNeeded;
    }

    void log(String message) {
        this.LOGGER.info(String.format("[%s] %s", ((Object)((Object)this)).getClass().getSimpleName(), message));
    }

    private void logError(String message) {
        this.LOGGER.error(String.format("[%s] %s", ((Object)((Object)this)).getClass().getSimpleName(), message));
    }

    void logError(String message, Throwable t) {
        this.LOGGER.error(String.format("[%s] %s", ((Object)((Object)this)).getClass().getSimpleName(), message), t);
    }

    public void flagOverlaysForRerender() {
        for (OverlayDrawStep overlayDrawStep : this.lastDrawSteps) {
            overlayDrawStep.getOverlay().flagForRerender();
        }
    }

    public UIState getLastUIState() {
        return this.lastUiState;
    }

    public HashBasedTable<String, Overlay, OverlayDrawStep> getOverlays(String modId, ResourceKey<Level> dimension) {
        return this.getPlugin(modId).getOverlays(dimension);
    }
}

