/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.popupscreenbutton.imageselect;

import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Supplier;
import journeymap.client.cartography.color.RGB;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.component.popupscreenbutton.PopupButton;
import journeymap.client.ui.component.popupscreenbutton.PopupButtonScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class ImageSelectButton<T>
extends PopupButton<T> {
    private ResourceLocation location;
    private int color;
    private final int imageWidth;
    private final int imageHeight;

    public ImageSelectButton(int width, int height, int imageWidth, int imageHeight, ResourceLocation location, Integer color, Component title, Supplier<PopupButtonScreen<T>> screen, PopupButtonScreen.OnClose<T> onClose) {
        super(width, height, title, screen, onClose);
        this.imageWidth = imageWidth;
        this.imageHeight = imageHeight;
        this.location = location;
        this.color = -1;
        if (color != null) {
            this.color = RGB.toInteger(RGB.floats(color, 255.0f));
        }
    }

    public void setColor(int color) {
        this.color = color;
    }

    public void setLocation(ResourceLocation location) {
        this.location = location;
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        super.renderWidget(graphics, mouseX, mouseY, partialTick);
        DynamicTexture tex = TextureCache.getTexture(this.location);
        RenderType renderType = JMRenderTypes.getIconNoBlur((AbstractTexture)tex);
        MultiBufferSource.BufferSource buffers = Minecraft.getInstance().renderBuffers().bufferSource();
        VertexConsumer vertexBuilder = buffers.getBuffer(renderType);
        DrawUtil.drawQuad(graphics, vertexBuilder, this.color, 1.0f, (double)(this.getX() + (this.imageWidth >> 3)), (double)(this.getY() + (this.imageHeight >> 3)), (double)this.imageWidth, (double)this.imageHeight, 0.0, false);
        buffers.endLastBatch();
    }

    public void renderString(GuiGraphics guiGraphics, Font font, int color) {
    }
}

