/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.component.popupscreenbutton.imageselect;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import journeymap.client.ui.component.SearchTextBox;
import journeymap.client.ui.component.popupscreenbutton.PopupButtonScreen;
import journeymap.client.ui.component.popupscreenbutton.colorpicker.ColorPickerButton;
import journeymap.client.ui.component.popupscreenbutton.colorpicker.ColorPickerScreen;
import journeymap.client.ui.component.popupscreenbutton.imageselect.ImageListSlot;
import journeymap.client.ui.component.popupscreenbutton.imageselect.ImageScrollListPane;
import journeymap.client.ui.component.popupscreenbutton.imageselect.ImageSlot;
import journeymap.client.ui.component.widgets.StringWidget;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class ImageSelectionScreen
extends PopupButtonScreen<Response> {
    private static final int PANE_WIDTH = 200;
    private static final int PANE_HEIGHT = 120;
    private SearchTextBox searchTextBox;
    private final ResourceLocation initialSelected;
    private ImageSlot selectedSlot;
    private final List<ResourceLocation> icons;
    private final ImageScrollListPane<ImageListSlot> scrollPane;
    private List<ImageListSlot> imageListSlots;
    private List<ImageSlot> imageSlots;
    private int color;
    private String searchText = "";
    private final ImageSlot previewImage;

    public ImageSelectionScreen(Component component, ResourceLocation initialSelected, List<ResourceLocation> icons, int color) {
        super(component);
        this.width = Minecraft.getInstance().getWindow().getGuiScaledWidth();
        this.height = Minecraft.getInstance().getWindow().getGuiScaledHeight();
        this.color = color;
        this.icons = icons;
        this.initialSelected = initialSelected;
        this.scrollPane = new ImageScrollListPane(0, 0, 0, 0, 24);
        this.previewImage = new ImageSlot(this.initialSelected, 16, 16, this.color);
        this.imageListSlots = this.buildSlots();
        this.updateColor(this.color);
    }

    public void init() {
        this.layout.addChild((LayoutElement)new StringWidget((Component)this.getTitle().copy().withStyle(ChatFormatting.AQUA).withStyle(ChatFormatting.UNDERLINE), this.font), LayoutSettings::alignHorizontallyCenter);
        this.layout.spacing(8);
        LinearLayout contentLayout = LinearLayout.vertical();
        contentLayout.spacing(8);
        this.layout.addChild((LayoutElement)contentLayout);
        LinearLayout headerLayout = LinearLayout.horizontal();
        headerLayout.spacing(10);
        this.searchTextBox = (SearchTextBox)headerLayout.addChild((LayoutElement)new SearchTextBox("", this.font, 70, 15), LayoutSettings::alignVerticallyMiddle);
        this.searchTextBox.setBordered(false);
        this.searchTextBox.setFillColor(0, 0.4f);
        this.searchTextBox.setResponder(this::updateSearch);
        headerLayout.addChild((LayoutElement)new ColorPickerButton(20, 20, () -> this.color, this::updateWaypointColor));
        headerLayout.addChild((LayoutElement)this.previewImage, LayoutSettings::alignVerticallyMiddle);
        this.previewImage.setOutline(true);
        contentLayout.addChild((LayoutElement)headerLayout);
        LinearLayout paneLayout = LinearLayout.horizontal();
        this.scrollPane.setSlots(this.imageListSlots);
        this.scrollPane.initSlots();
        paneLayout.addChild(this.scrollPane);
        contentLayout.addChild((LayoutElement)paneLayout);
        LinearLayout bottomLayout = LinearLayout.horizontal();
        bottomLayout.spacing(10);
        bottomLayout.addChild((LayoutElement)Button.builder((Component)Component.translatable((String)"jm.waypoint.save"), b -> this.exit(false)).width(this.font.width((FormattedText)CommonComponents.GUI_CONTINUE) + 10).build());
        bottomLayout.addChild((LayoutElement)Button.builder((Component)CommonComponents.GUI_CANCEL, b -> this.exit(true)).width(this.font.width((FormattedText)CommonComponents.GUI_CANCEL) + 10).build());
        this.layout.addChild((LayoutElement)bottomLayout, LayoutSettings::alignHorizontallyCenter);
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.scrollPane.visitSlots(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addWidget((GuiEventListener)x$0);
        });
        this.repositionElements();
        this.scrollPane.updateSize(200, 120, paneLayout.getX(), paneLayout.getY());
    }

    private void exit(boolean cancel) {
        this.setResponseAndClose(new Response(this.selectedSlot.getImage(), this.color, cancel));
    }

    private void updateWaypointColor(ColorPickerScreen.ColorPickerResponse colorPickerResponse) {
        if (!colorPickerResponse.canceled()) {
            this.updateColor(colorPickerResponse.color());
        }
    }

    @Override
    protected void repositionElements() {
        this.layout.arrangeElements();
        this.scrollPane.repositionSlots();
        this.scrollPane.updateSize(200, 120, 0, 0);
        super.repositionElements();
    }

    private void updateColor(int color) {
        this.color = color;
        this.imageListSlots.forEach(slot -> slot.updateColor(color));
        this.previewImage.setColor(color);
    }

    private List<ImageListSlot> buildSlots() {
        ArrayList<ImageListSlot> slots = new ArrayList<ImageListSlot>();
        int columns = 8;
        ImageListSlot slot = new ImageListSlot();
        if (this.imageSlots == null) {
            this.imageSlots = new ArrayList<ImageSlot>();
            this.icons.forEach(icon -> {
                ImageSlot image = new ImageSlot((ResourceLocation)icon, 16, 16, this.color);
                if (icon.equals((Object)this.initialSelected)) {
                    this.updateSelectedSlot(image);
                }
                this.imageSlots.add(image);
            });
        }
        List<ImageSlot> filteredSlots = this.getFilteredSlots();
        for (int i = 0; i < filteredSlots.size(); ++i) {
            ImageSlot image = filteredSlots.get(i);
            if (i % columns == 0) {
                slot = new ImageListSlot();
                slots.add(slot);
            }
            slot.addImage(image);
        }
        return slots;
    }

    private List<ImageSlot> getFilteredSlots() {
        Stream<Object> stream = this.imageSlots.stream();
        if (this.searchText != null && !this.searchText.isEmpty()) {
            stream = stream.filter(slot -> slot.fileName().toLowerCase().contains(this.searchText.toLowerCase()));
        }
        return stream.sorted(Comparator.comparing(ImageSlot::fileName)).toList();
    }

    private void updateSearch(String searchText) {
        if (!this.searchText.equals(searchText)) {
            this.searchText = searchText;
            this.updateSlots();
        }
    }

    private void updateSlots() {
        this.scrollPane.setScrollAmount(0.0);
        this.scrollPane.visitSlots(x$0 -> this.removeWidget((GuiEventListener)x$0));
        this.imageListSlots.clear();
        this.imageListSlots = this.buildSlots();
        this.scrollPane.setSlots(this.imageListSlots);
        this.scrollPane.initSlots();
        this.scrollPane.visitSlots(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addWidget((GuiEventListener)x$0);
        });
        this.scrollPane.updateSlots();
        this.scrollPane.repositionSlots();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Optional slot;
        if (this.scrollPane.isMouseOver(mouseX, mouseY) && (slot = this.scrollPane.getChildAt(mouseX, mouseY)).isPresent()) {
            ImageListSlot clickedSlot = (ImageListSlot)((Object)slot.get());
            Optional<GuiEventListener> childSlot = clickedSlot.getChildAt(mouseX, mouseY);
            childSlot.ifPresent(guiEventListener -> this.updateSelectedSlot((ImageSlot)guiEventListener));
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    private void updateSelectedSlot(ImageSlot slot) {
        if (this.selectedSlot != null) {
            this.selectedSlot.setOutline(false);
        }
        this.previewImage.setImage(slot.getImage());
        this.selectedSlot = slot;
        slot.setOutline(true);
    }

    public record Response(ResourceLocation resourceLocation, int color, boolean cancelled) {
    }
}

