/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.sql.dto.util;

import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataInputStream;
import com.seibel.distanthorizons.core.util.objects.dataStreams.DhDataOutputStream;
import java.io.IOException;

public class VarintUtil {
    public static int zigzagEncode(int n) {
        return n << 1 ^ n >> 31;
    }

    public static int zigzagDecode(int n) {
        return n >>> 1 ^ -(n & 1);
    }

    public static void writeVarint(DhDataOutputStream out, int value) throws IOException {
        if (value < 0) {
            throw new IllegalArgumentException("varint given [" + value + "], varint only accepts positive values.");
        }
        while (value >= 128) {
            out.writeByte(value | 0x80);
            value >>>= 7;
        }
        out.writeByte(value);
    }

    public static int readVarint(DhDataInputStream in) throws IOException {
        byte b;
        int value = 0;
        int shift = 0;
        do {
            if (shift >= 32) {
                throw new IOException("invalid varint");
            }
            b = in.readByte();
            value |= (b & 0x7F) << shift;
            shift += 7;
        } while ((b & 0x80) != 0);
        return value;
    }
}

