/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz;

import java.io.IOException;
import java.io.OutputStream;
import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.BlockOutputStream;
import org.tukaani.xz.FilterCoder;
import org.tukaani.xz.FilterEncoder;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.FinishableOutputStream;
import org.tukaani.xz.RawCoder;
import org.tukaani.xz.UnsupportedOptionsException;
import org.tukaani.xz.XZ;
import org.tukaani.xz.XZIOException;
import org.tukaani.xz.check.Check;
import org.tukaani.xz.common.EncoderUtil;
import org.tukaani.xz.common.StreamFlags;
import org.tukaani.xz.index.IndexEncoder;

public class XZOutputStream
extends FinishableOutputStream {
    private final ArrayCache arrayCache;
    private OutputStream out;
    private final StreamFlags streamFlags = new StreamFlags();
    private final Check check;
    private final IndexEncoder index = new IndexEncoder();
    private BlockOutputStream blockEncoder = null;
    private FilterEncoder[] filters;
    private boolean filtersSupportFlushing;
    private IOException exception = null;
    private boolean finished = false;
    private final byte[] tempBuf = new byte[1];

    public XZOutputStream(OutputStream outputStream, FilterOptions filterOptions) throws IOException {
        this(outputStream, filterOptions, 4);
    }

    public XZOutputStream(OutputStream outputStream, FilterOptions filterOptions, ArrayCache arrayCache) throws IOException {
        this(outputStream, filterOptions, 4, arrayCache);
    }

    public XZOutputStream(OutputStream outputStream, FilterOptions filterOptions, int i) throws IOException {
        this(outputStream, new FilterOptions[]{filterOptions}, i);
    }

    public XZOutputStream(OutputStream outputStream, FilterOptions filterOptions, int i, ArrayCache arrayCache) throws IOException {
        this(outputStream, new FilterOptions[]{filterOptions}, i, arrayCache);
    }

    public XZOutputStream(OutputStream outputStream, FilterOptions[] filterOptionss) throws IOException {
        this(outputStream, filterOptionss, 4);
    }

    public XZOutputStream(OutputStream outputStream, FilterOptions[] filterOptionss, ArrayCache arrayCache) throws IOException {
        this(outputStream, filterOptionss, 4, arrayCache);
    }

    public XZOutputStream(OutputStream outputStream, FilterOptions[] filterOptionss, int i) throws IOException {
        this(outputStream, filterOptionss, i, ArrayCache.getDefaultCache());
    }

    public XZOutputStream(OutputStream outputStream, FilterOptions[] filterOptionss, int i, ArrayCache arrayCache) throws IOException {
        this.arrayCache = arrayCache;
        this.out = outputStream;
        this.updateFilters(filterOptionss);
        this.streamFlags.checkType = i;
        this.check = Check.getInstance(i);
        this.encodeStreamHeader();
    }

    public void updateFilters(FilterOptions filterOptions) throws XZIOException {
        FilterOptions[] filterOptionsArray = new FilterOptions[]{filterOptions};
        this.updateFilters(filterOptionsArray);
    }

    public void updateFilters(FilterOptions[] filterOptionss) throws XZIOException {
        if (this.blockEncoder != null) {
            throw new UnsupportedOptionsException("Changing filter options in the middle of a XZ Block not implemented");
        }
        if (filterOptionss.length < 1 || filterOptionss.length > 4) {
            throw new UnsupportedOptionsException("XZ filter chain must be 1-4 filters");
        }
        this.filtersSupportFlushing = true;
        FilterCoder[] filterCoderArray = new FilterEncoder[filterOptionss.length];
        for (int i = 0; i < filterOptionss.length; ++i) {
            filterCoderArray[i] = filterOptionss[i].getFilterEncoder();
            this.filtersSupportFlushing &= filterCoderArray[i].supportsFlushing();
        }
        RawCoder.validate(filterCoderArray);
        this.filters = filterCoderArray;
    }

    @Override
    public void write(int i) throws IOException {
        this.tempBuf[0] = (byte)i;
        this.write(this.tempBuf, 0, 1);
    }

    @Override
    public void write(byte[] bs, int i, int j) throws IOException {
        if (i < 0 || j < 0 || i + j < 0 || i + j > bs.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.finished) {
            throw new XZIOException("Stream finished or closed");
        }
        try {
            if (this.blockEncoder == null) {
                this.blockEncoder = new BlockOutputStream(this.out, this.filters, this.check, this.arrayCache);
            }
            this.blockEncoder.write(bs, i, j);
        }
        catch (IOException iOException) {
            this.exception = iOException;
            throw iOException;
        }
    }

    public void endBlock() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.finished) {
            throw new XZIOException("Stream finished or closed");
        }
        if (this.blockEncoder != null) {
            try {
                this.blockEncoder.finish();
                this.index.add(this.blockEncoder.getUnpaddedSize(), this.blockEncoder.getUncompressedSize());
                this.blockEncoder = null;
            }
            catch (IOException iOException) {
                this.exception = iOException;
                throw iOException;
            }
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.finished) {
            throw new XZIOException("Stream finished or closed");
        }
        try {
            if (this.blockEncoder != null) {
                if (this.filtersSupportFlushing) {
                    this.blockEncoder.flush();
                } else {
                    this.endBlock();
                    this.out.flush();
                }
            } else {
                this.out.flush();
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
            throw iOException;
        }
    }

    @Override
    public void finish() throws IOException {
        if (!this.finished) {
            this.endBlock();
            try {
                this.index.encode(this.out);
                this.encodeStreamFooter();
            }
            catch (IOException iOException) {
                this.exception = iOException;
                throw iOException;
            }
            this.finished = true;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.out != null) {
            block6: {
                try {
                    this.finish();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    if (this.exception != null) break block6;
                    this.exception = iOException;
                }
            }
            this.out = null;
        }
        if (this.exception != null) {
            throw this.exception;
        }
    }

    private void encodeStreamFlags(byte[] bs, int i) {
        bs[i] = 0;
        bs[i + 1] = (byte)this.streamFlags.checkType;
    }

    private void encodeStreamHeader() throws IOException {
        this.out.write(XZ.HEADER_MAGIC);
        byte[] byArray = new byte[2];
        this.encodeStreamFlags(byArray, 0);
        this.out.write(byArray);
        EncoderUtil.writeCRC32(this.out, byArray);
    }

    private void encodeStreamFooter() throws IOException {
        byte[] byArray = new byte[6];
        long l = this.index.getIndexSize() / 4L - 1L;
        for (int i = 0; i < 4; ++i) {
            byArray[i] = (byte)(l >>> i * 8);
        }
        this.encodeStreamFlags(byArray, 4);
        EncoderUtil.writeCRC32(this.out, byArray);
        this.out.write(byArray);
        this.out.write(XZ.FOOTER_MAGIC);
    }
}

