/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.mixin;

import com.copycatsplus.copycats.compat.Mods;
import com.copycatsplus.copycats.foundation.annotation.ModMixin;
import com.llamalad7.mixinextras.MixinExtrasBootstrap;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AnnotationNode;
import org.objectweb.asm.tree.ClassNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import org.spongepowered.asm.service.MixinService;
import org.spongepowered.asm.util.Annotations;

public class MixinPlugin
implements IMixinConfigPlugin {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Copycats+ | MixinPlugin");
    private boolean isFrameworkInstalled;

    public void onLoad(String mixinPackage) {
        MixinExtrasBootstrap.init();
        try {
            Class.forName("com.copycatsplus.copycats.Copycats", false, this.getClass().getClassLoader());
            this.isFrameworkInstalled = true;
        }
        catch (Exception e) {
            this.isFrameworkInstalled = false;
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        try {
            List annotationNodes = MixinService.getService().getBytecodeProvider().getClassNode((String)mixinClassName).visibleAnnotations;
            if (annotationNodes == null) {
                return true;
            }
            boolean shouldApply = true;
            for (AnnotationNode node : annotationNodes) {
                if (!node.desc.equals(Type.getDescriptor(ModMixin.class))) continue;
                List mods = Annotations.getValue((AnnotationNode)node, (String)"requiredMods", (boolean)true, Mods.class);
                boolean applyIfPresent = (Boolean)Annotations.getValue((AnnotationNode)node, (String)"applyIfPresent", (Object)Boolean.TRUE);
                boolean anyModsLoaded = MixinPlugin.anyModsLoaded(mods);
                shouldApply = anyModsLoaded == applyIfPresent;
                LOGGER.debug("{} is {} being applied because the mod(s) {} are {} loaded", new Object[]{mixinClassName, shouldApply ? " " : " not ", mods, anyModsLoaded ? " " : " not "});
            }
            return shouldApply;
        }
        catch (IOException | ClassNotFoundException e) {
            LOGGER.error("An error occurred when checking if {} has the ModMixin annotation", (Object)mixinClassName, (Object)e);
            return this.isFrameworkInstalled;
        }
    }

    private static boolean anyModsLoaded(List<Mods> mods) {
        for (Mods mod : mods) {
            if (!mod.isLoaded) continue;
            return true;
        }
        return false;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

