/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.client.render.entity.model;

import aqario.fowlplay.client.render.entity.animation.SparrowAnimations;
import aqario.fowlplay.client.render.entity.model.FlyingBirdModel;
import aqario.fowlplay.common.entity.SparrowEntity;
import aqario.fowlplay.core.FowlPlay;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class SparrowModel
extends FlyingBirdModel<SparrowEntity> {
    public static final ModelLayerLocation MODEL_LAYER = new ModelLayerLocation(FowlPlay.id("sparrow"), "main");

    public SparrowModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition root = modelPartData.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)21.0f, (float)-1.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.25f, (float)1.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 12).addBox(-1.0f, -1.5f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(-0.001f)), PartPose.offset((float)0.0f, (float)-1.0f, (float)-2.0f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 7).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-0.5f, (float)0.0f));
        head.addOrReplaceChild("beak", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -3.0f, -1.0f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)1.0f, (float)-1.0f));
        body.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -2.0f, -3.0f, 3.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(14, 0).addBox(-1.5f, -1.0f, -0.5f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)-2.25f, (float)-1.25f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(14, 0).mirror().addBox(-0.5f, -1.0f, -0.5f, 2.0f, 2.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.5f, (float)-2.25f, (float)-1.25f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition left_wing_open = body.addOrReplaceChild("left_wing_open", CubeListBuilder.create().texOffs(8, 7).addBox(-0.5f, 0.0f, -1.0f, 5.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-2.5f, (float)-0.5f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        left_wing_open.addOrReplaceChild("left_wing_outer", CubeListBuilder.create().texOffs(3, 13).addBox(0.0f, 0.0f, 0.0f, 5.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.offset((float)4.5f, (float)0.0f, (float)-1.0f));
        PartDefinition right_wing_open = body.addOrReplaceChild("right_wing_open", CubeListBuilder.create().texOffs(8, 7).mirror().addBox(-4.5f, 0.0f, -1.0f, 5.0f, 1.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.0f, (float)-2.5f, (float)-0.5f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        right_wing_open.addOrReplaceChild("right_wing_outer", CubeListBuilder.create().texOffs(3, 13).mirror().addBox(-5.0f, 0.0f, 0.0f, 5.0f, 0.0f, 5.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-4.5f, (float)0.0f, (float)-1.0f));
        body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(10, 0).addBox(-1.0f, -1.0f, 1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(20, 0).addBox(-1.0f, -1.0f, 3.0f, 2.0f, 0.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.25f, (float)0.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition left_leg = root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(9, 8).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)1.0f, (float)1.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        left_leg.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(7, 7).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(9, 8).addBox(-0.5f, 0.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)1.0f, (float)1.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        right_leg.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(7, 7).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)32, (int)32);
    }

    @Override
    protected void setAnimations(SparrowEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float partialTick) {
        if (!entity.isFlying() && !entity.isInWaterOrBubble()) {
            this.animateWalk(SparrowAnimations.WALKING, limbSwing, limbSwingAmount, 6.0f, 6.0f);
        }
        this.animate(entity.standingState, SparrowAnimations.STANDING, ageInTicks);
        this.animate(entity.swimmingState, SparrowAnimations.SWIMMING, ageInTicks);
        this.animate(entity.glidingState, SparrowAnimations.GLIDING, ageInTicks);
        this.animate(entity.flappingState, SparrowAnimations.FLAPPING, ageInTicks);
        this.animate(entity.preeningState, SparrowAnimations.PREENING, ageInTicks);
        this.animate(entity.scratchingState, SparrowAnimations.SCRATCHING, ageInTicks);
    }

    @Override
    protected boolean shouldRenderWings(SparrowEntity entity) {
        return super.shouldRenderWings(entity) && entity.flappingState.isStarted();
    }
}

