/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.util.PathBuilder;
import aqario.fowlplay.core.FowlPlay;
import aqario.fowlplay.core.FowlPlayRegistries;
import aqario.fowlplay.core.platform.PlatformHelper;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;

public record GooseVariant(String id, ModelType modelType, Optional<ResourceLocation> domesticId) {
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<GooseVariant>> PACKET_CODEC = ByteBufCodecs.holderRegistry(FowlPlayRegistries.GOOSE_VARIANT);
    public static final ResourceKey<GooseVariant> CANADA = GooseVariant.registerWild("canada");
    public static final ResourceKey<GooseVariant> GREYLAG = GooseVariant.registerWild("greylag", "emden");
    public static final ResourceKey<GooseVariant> SWAN = GooseVariant.registerWild("swan", "chinese");
    public static final ResourceKey<GooseVariant> EMDEN = GooseVariant.registerDomestic("emden");
    public static final ResourceKey<GooseVariant> CHINESE = GooseVariant.registerDomestic("chinese");

    public ResourceLocation texture(boolean isBaby) {
        return FowlPlay.id(new PathBuilder().add("textures/entity/goose/").addIf("baby_", isBaby).add(this.id).add("_goose.png"));
    }

    private static ResourceKey<GooseVariant> registerWild(String id) {
        return GooseVariant.register(id, ModelType.WILD, Optional.empty());
    }

    private static ResourceKey<GooseVariant> registerWild(String id, String domesticId) {
        return GooseVariant.register(id, ModelType.WILD, Optional.of(domesticId));
    }

    private static ResourceKey<GooseVariant> registerDomestic(String id) {
        return GooseVariant.register(id, ModelType.DOMESTIC, Optional.empty());
    }

    private static ResourceKey<GooseVariant> register(String id, ModelType modelType, Optional<String> domesticId) {
        ResourceKey key = ResourceKey.create(FowlPlayRegistries.GOOSE_VARIANT, (ResourceLocation)FowlPlay.id(id));
        PlatformHelper.registerVariant(id, key, () -> new GooseVariant(id, modelType, domesticId.map(FowlPlay::id)));
        return key;
    }

    public static void init() {
    }

    public static enum ModelType implements StringRepresentable
    {
        WILD("wild"),
        DOMESTIC("domestic");

        private final String name;

        private ModelType(String name) {
            this.name = name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

