/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain.behaviour;

import aqario.fowlplay.common.entity.BirdEntity;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.tslat.smartbrainlib.api.core.behaviour.ExtendedBehaviour;

public class AnonymousBehaviour<E extends BirdEntity>
extends ExtendedBehaviour<E> {
    private final List<Pair<MemoryModuleType<?>, MemoryStatus>> requiredMemories;
    private final Predicate<E> callback;

    public AnonymousBehaviour(List<Pair<MemoryModuleType<?>, MemoryStatus>> requiredMemories, Predicate<E> callback) {
        this.requiredMemories = requiredMemories;
        this.callback = callback;
        for (Pair<MemoryModuleType<?>, MemoryStatus> memory : requiredMemories) {
            this.entryCondition.put((MemoryModuleType)memory.getFirst(), (MemoryStatus)memory.getSecond());
        }
    }

    public AnonymousBehaviour(Predicate<E> callback) {
        this.requiredMemories = List.of();
        this.callback = callback;
    }

    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return List.of();
    }

    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        Brain brain = entity.getBrain();
        for (Pair<MemoryModuleType<?>, MemoryStatus> memoryPair : this.requiredMemories) {
            if (brain.checkMemory((MemoryModuleType)memoryPair.getFirst(), (MemoryStatus)memoryPair.getSecond())) continue;
            return false;
        }
        return this.callback.test(entity);
    }
}

