/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.brain.sensor;

import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.core.FowlPlayMemoryTypes;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Unit;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.item.ItemEntity;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.registry.SBLMemoryTypes;
import net.tslat.smartbrainlib.registry.SBLSensors;
import net.tslat.smartbrainlib.util.BrainUtils;
import net.tslat.smartbrainlib.util.EntityRetrievalUtil;

public class NearbyFoodSensor<E extends BirdEntity>
extends PredicateSensor<ItemEntity, E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{(MemoryModuleType)SBLMemoryTypes.NEARBY_ITEMS.get()});

    public NearbyFoodSensor() {
        super((item, bird) -> bird.wantsToPickUp(item.getItem()) && bird.hasLineOfSight((Entity)item));
    }

    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    public SensorType<? extends ExtendedSensor<?>> type() {
        return (SensorType)SBLSensors.NEARBY_ITEMS.get();
    }

    protected void doTick(ServerLevel world, E bird) {
        Brain brain = bird.getBrain();
        double radius = bird.getAttributeValue(Attributes.FOLLOW_RANGE);
        List nearbyItems = EntityRetrievalUtil.getEntities(bird, (double)radius, ItemEntity.class, item -> this.predicate().test(item, bird));
        BrainUtils.setMemory((Brain)brain, (MemoryModuleType)((MemoryModuleType)SBLMemoryTypes.NEARBY_ITEMS.get()), (Object)nearbyItems);
        if (Birds.canPickupFood(bird)) {
            BrainUtils.setMemory((Brain)brain, FowlPlayMemoryTypes.SEES_FOOD.get(), (Object)Unit.INSTANCE);
        } else {
            BrainUtils.clearMemory((Brain)brain, FowlPlayMemoryTypes.SEES_FOOD.get());
        }
    }
}

