/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.util;

import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.util.CylindricalRadius;
import aqario.fowlplay.core.tags.FowlPlayBlockTags;
import com.mojang.datafixers.util.Pair;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.util.GoalUtils;
import net.minecraft.world.entity.ai.util.RandomPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class TargetingUtil {
    @Nullable
    public static BlockPos tryFindAir(FlyingBirdEntity entity, CylindricalRadius range, BlockPos pos) {
        BlockPos adjustedPos = RandomPos.generateRandomPosTowardDirection((PathfinderMob)entity, (int)range.horizontal(), (RandomSource)entity.getRandom(), (BlockPos)pos);
        adjustedPos = TargetingUtil.shiftPosTowardsFlyHeightRange(entity, adjustedPos);
        int surfaceY = entity.level().getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, adjustedPos.getX(), adjustedPos.getZ());
        if (adjustedPos.getY() < surfaceY && entity.getY() >= (double)surfaceY) {
            adjustedPos = adjustedPos.atY(surfaceY + 12);
        } else if (entity.getY() < (double)surfaceY) {
            adjustedPos = RandomPos.moveUpOutOfSolid((BlockPos)adjustedPos, (int)entity.level().getMaxBuildHeight(), currentPos -> GoalUtils.isSolid((PathfinderMob)entity, (BlockPos)currentPos) || GoalUtils.isWater((PathfinderMob)entity, (BlockPos)currentPos));
        }
        if (GoalUtils.isSolid((PathfinderMob)entity, (BlockPos)adjustedPos) || GoalUtils.isWater((PathfinderMob)entity, (BlockPos)adjustedPos) || GoalUtils.hasMalus((PathfinderMob)entity, (BlockPos)adjustedPos)) {
            return null;
        }
        return adjustedPos;
    }

    @Nullable
    public static BlockPos tryFindWater(PathfinderMob entity, CylindricalRadius range, BlockPos pos) {
        BlockPos adjustedPos = TargetingUtil.findSurfacePosition(entity, pos, range, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, 0, currentPos -> GoalUtils.isSolid((PathfinderMob)entity, (BlockPos)currentPos) || GoalUtils.isWater((PathfinderMob)entity, (BlockPos)currentPos));
        if (!GoalUtils.isWater((PathfinderMob)entity, (BlockPos)adjustedPos)) {
            return null;
        }
        return adjustedPos;
    }

    @Nullable
    public static BlockPos tryFindNonAir(PathfinderMob entity, CylindricalRadius range, BlockPos pos) {
        BlockPos adjustedPos = TargetingUtil.findSurfacePosition(entity, pos, range, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, 0, currentPos -> GoalUtils.isSolid((PathfinderMob)entity, (BlockPos)currentPos) || GoalUtils.isWater((PathfinderMob)entity, (BlockPos)currentPos));
        if (GoalUtils.hasMalus((PathfinderMob)entity, (BlockPos)adjustedPos) || !TargetingUtil.isPositionNonAir(entity, adjustedPos)) {
            return null;
        }
        return entity.level().isWaterAt(adjustedPos) ? adjustedPos : adjustedPos.above();
    }

    @Nullable
    public static BlockPos tryFindGround(PathfinderMob entity, CylindricalRadius range, BlockPos pos) {
        BlockPos adjustedPos = TargetingUtil.findSurfacePosition(entity, pos, range, Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, 1, currentPos -> GoalUtils.isSolid((PathfinderMob)entity, (BlockPos)currentPos));
        if (GoalUtils.isWater((PathfinderMob)entity, (BlockPos)adjustedPos) || GoalUtils.hasMalus((PathfinderMob)entity, (BlockPos)adjustedPos) || !TargetingUtil.isPositionGrounded(entity, adjustedPos.below())) {
            return null;
        }
        return adjustedPos;
    }

    @Nullable
    public static BlockPos tryFindPerch(PathfinderMob entity, CylindricalRadius range, BlockPos pos) {
        BlockPos adjustedPos = TargetingUtil.findSurfacePosition(entity, pos, range, Heightmap.Types.MOTION_BLOCKING, 0, currentPos -> {
            boolean isValidPerch;
            boolean isLeaves = entity.level().getBlockState(currentPos.below()).getBlock() instanceof LeavesBlock;
            boolean isValidLeavesPerch = isLeaves && !entity.level().getBlockState(currentPos.below(2)).isAir();
            boolean bl = isValidPerch = TargetingUtil.isPerch(entity, currentPos.below()) && entity.level().getBlockState(currentPos).isAir();
            if (isLeaves && !isValidLeavesPerch) {
                return true;
            }
            if (isValidLeavesPerch) {
                return false;
            }
            return !isValidPerch;
        });
        if (!TargetingUtil.isPerch(entity, adjustedPos) || GoalUtils.isWater((PathfinderMob)entity, (BlockPos)adjustedPos) || GoalUtils.hasMalus((PathfinderMob)entity, (BlockPos)adjustedPos)) {
            return null;
        }
        return entity.level().getBlockState(adjustedPos).getBlock() instanceof LeavesBlock ? adjustedPos : adjustedPos.above();
    }

    public static BlockPos findSurfacePosition(PathfinderMob entity, BlockPos initialPos, CylindricalRadius range, Heightmap.Types heightmap, int blocksAbove, Predicate<BlockPos> predicate) {
        BlockPos adjustedPos = RandomPos.generateRandomPosTowardDirection((PathfinderMob)entity, (int)range.horizontal(), (RandomSource)entity.getRandom(), (BlockPos)initialPos);
        int surfaceY = entity.level().getHeight(heightmap, adjustedPos.getX(), adjustedPos.getZ());
        adjustedPos = adjustedPos.getY() >= surfaceY ? adjustedPos.atY(surfaceY + blocksAbove - 1) : RandomPos.moveUpOutOfSolid((BlockPos)adjustedPos, (int)surfaceY, predicate).relative(Direction.Axis.Y, blocksAbove - 1);
        return adjustedPos;
    }

    @Nullable
    public static BlockPos validateBlockPos(PathfinderMob entity, @Nullable BlockPos pos, CylindricalRadius range) {
        if (pos == null) {
            return null;
        }
        if (GoalUtils.isOutsideLimits((BlockPos)pos, (PathfinderMob)entity) || GoalUtils.isRestricted((boolean)GoalUtils.mobRestricted((PathfinderMob)entity, (int)range.horizontal()), (PathfinderMob)entity, (BlockPos)pos)) {
            return null;
        }
        return pos;
    }

    @Nullable
    public static Vec3 validatePos(PathfinderMob entity, @Nullable BlockPos pos, CylindricalRadius range) {
        BlockPos validPos = TargetingUtil.validateBlockPos(entity, pos, range);
        return validPos != null ? validPos.getBottomCenter() : null;
    }

    public static BlockPos shiftPosTowardsFlyHeightRange(FlyingBirdEntity bird, BlockPos pos) {
        int posY = pos.getY();
        RandomSource random = bird.getRandom();
        Pair<Integer, Integer> flyHeightRange = bird.getFlyHeightRange();
        int lower = (Integer)flyHeightRange.getFirst();
        int upper = (Integer)flyHeightRange.getSecond();
        if (posY < lower) {
            return pos.above(Math.min(random.nextIntBetweenInclusive(5, 10), lower - posY));
        }
        if (posY > upper) {
            return pos.below(Math.min(random.nextIntBetweenInclusive(5, 10), posY - upper));
        }
        return pos;
    }

    public static boolean isPerch(PathfinderMob entity, BlockPos pos) {
        return entity.level().getBlockState(pos).is(FowlPlayBlockTags.PERCHES);
    }

    public static boolean isPositionNonAir(PathfinderMob entity, BlockPos pos) {
        return TargetingUtil.isFullBlockAt(entity, pos) || GoalUtils.isWater((PathfinderMob)entity, (BlockPos)pos);
    }

    public static boolean isPositionGrounded(PathfinderMob entity, BlockPos pos) {
        return TargetingUtil.isFullBlockAt(entity, pos);
    }

    public static boolean isFullBlockAt(PathfinderMob entity, BlockPos pos) {
        return entity.level().getBlockState(pos).isSolidRender((BlockGetter)entity.level(), pos);
    }

    public static boolean isWithinAngle(Vec3 normalVec, Vec3 targetVec, double angle) {
        float cosMaxAngle;
        float cosVectorAngle = (float)(normalVec = normalVec.normalize()).dot(targetVec = targetVec.normalize());
        return cosVectorAngle >= (cosMaxAngle = Mth.cos((float)((float)angle)));
    }

    public static boolean isPosWithinViewAngle(PathfinderMob entity, BlockPos pos, double angle) {
        Vec3 lookVec = entity.getViewVector(1.0f);
        Vec3 target = Vec3.atCenterOf((Vec3i)pos);
        Vec3 targetVec = target.subtract(entity.position());
        return TargetingUtil.isWithinAngle(lookVec, targetVec, angle);
    }
}

