/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.colorpalette;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import journeymap.client.Constants;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.RGB;
import journeymap.client.properties.CoreProperties;
import journeymap.client.render.draw.DrawUtil;
import journeymap.client.texture.TextureAccess;
import journeymap.client.texture.TextureCache;
import journeymap.client.ui.UIManager;
import journeymap.client.ui.component.MultiSelectableScrollListPane;
import journeymap.client.ui.component.Slot;
import journeymap.client.ui.component.buttons.Button;
import journeymap.client.ui.component.popupscreenbutton.colorpicker.ColorPickerButton;
import journeymap.client.ui.component.popupscreenbutton.colorpicker.ColorPickerScreen;
import journeymap.client.ui.component.screens.JmUI;
import journeymap.client.ui.fullscreen.Fullscreen;
import journeymap.client.ui.option.SlotMetadata;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import journeymap.common.properties.config.StringField;
import net.minecraft.Util;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.layouts.SpacerElement;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class MobsAndPlayersColorEditor
extends JmUI {
    private final String labelSelectAll = Constants.getString("jm.colorpalette.select_all");
    private final String labelSelectSameColor = Constants.getString("jm.colorpalette.select_same_color");
    private final String labelSave = Constants.getString("jm.waypoint.save");
    private final Component labelClose = Component.translatable((String)"jm.common.close");
    LinearLayout buttonHeaderLayout;
    private Button buttonSave;
    private Button buttonSelectAll;
    private Button buttonSelectSameColor;
    int buttonHeaderHeight = 15;
    private MultiSelectableScrollListPane<DotLabelColorItem> dotLabelScrollPane;

    public MobsAndPlayersColorEditor(Screen returnDisplay) {
        super(Constants.getString("jm.colorpalette.edit_title"), true, returnDisplay);
    }

    @Override
    public void init() {
        super.init();
        LinearLayout content = LinearLayout.vertical();
        this.contentLayout.addChild((LayoutElement)content);
        this.buttonHeaderLayout = LinearLayout.horizontal();
        this.buttonHeaderLayout.spacing(2);
        content.addChild((LayoutElement)this.buttonHeaderLayout, LayoutSettings::alignHorizontallyCenter);
        this.buttonHeaderLayout.addChild((LayoutElement)SpacerElement.height((int)this.buttonHeaderHeight));
        CoreProperties coreProperties = JourneymapClient.getInstance().getCoreProperties();
        ResourceLocation dotTexture = TextureCache.MobDotArrow;
        ArrayList<DotLabelColorItem> dotLabelItemList = new ArrayList<DotLabelColorItem>();
        dotLabelItemList.add(new DotLabelColorItem(this.font, "jm.colorpalette.self_arrow", coreProperties.colorSelf, TextureCache.PlayerArrowBG, TextureCache.PlayerArrow, this));
        dotLabelItemList.add(new DotLabelColorItem(this.font, "jm.colorpalette.passive_dot", coreProperties.colorPassive, null, dotTexture, this));
        dotLabelItemList.add(new DotLabelColorItem(this.font, "jm.colorpalette.passive_label", coreProperties.colorPassiveLabel, "jm.colorpalette.example_label", this));
        dotLabelItemList.add(new DotLabelColorItem(this.font, "jm.colorpalette.hostile_dot", coreProperties.colorHostile, null, dotTexture, this));
        dotLabelItemList.add(new DotLabelColorItem(this.font, "jm.colorpalette.hostile_label", coreProperties.colorHostileLabel, "jm.colorpalette.example_label", this));
        dotLabelItemList.add(new DotLabelColorItem(this.font, "jm.colorpalette.pet_dot", coreProperties.colorPet, null, dotTexture, this));
        dotLabelItemList.add(new DotLabelColorItem(this.font, "jm.colorpalette.pet_label", coreProperties.colorPetLabel, "jm.colorpalette.example_label", this));
        dotLabelItemList.add(new DotLabelColorItem(this.font, "jm.colorpalette.villager_dot", coreProperties.colorVillager, null, dotTexture, this));
        dotLabelItemList.add(new DotLabelColorItem(this.font, "jm.colorpalette.villager_label", coreProperties.colorVillagerLabel, "jm.colorpalette.example_label", this));
        dotLabelItemList.add(new DotLabelColorItem(this.font, "jm.colorpalette.player_dot", coreProperties.colorPlayer, null, dotTexture, this));
        dotLabelItemList.add(new DotLabelColorItem(this.font, "jm.colorpalette.player_label", coreProperties.colorPlayerLabel, "jm.colorpalette.example_label", this));
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        this.dotLabelScrollPane = (MultiSelectableScrollListPane)content.addChild(new MultiSelectableScrollListPane(this.minecraft, 0, 36 + this.buttonHeaderHeight, this.width, this.height - 36 - 30 - this.buttonHeaderHeight, 30));
        this.dotLabelScrollPane.setSlots(dotLabelItemList);
        this.buttonSelectAll = (Button)this.buttonHeaderLayout.addChild((LayoutElement)new Button(this.labelSelectAll, b -> this.dotLabelScrollPane.selectAll()), LayoutSettings::alignVerticallyMiddle);
        this.buttonSelectAll.setHeight(this.buttonHeaderHeight);
        this.buttonSelectAll.setTextOnly(this.getFontRenderer());
        this.buttonSelectAll.drawUnderline(true);
        this.buttonSelectAll.setEnabled(this.dotLabelScrollPane.getRootSlots().size() > 1);
        this.buttonSelectSameColor = (Button)this.buttonHeaderLayout.addChild((LayoutElement)new Button(this.labelSelectSameColor, b -> {
            DotLabelColorItem selected = (DotLabelColorItem)this.dotLabelScrollPane.getSelected();
            if (selected != null) {
                for (DotLabelColorItem item : this.dotLabelScrollPane.getRootSlots()) {
                    if (item.color != selected.color) continue;
                    this.dotLabelScrollPane.setSelectedAndKeepCurrent(item);
                }
            }
        }), LayoutSettings::alignVerticallyMiddle);
        this.buttonSelectSameColor.setHeight(this.buttonHeaderHeight);
        this.buttonSelectSameColor.setTextOnly(this.getFontRenderer());
        this.buttonSelectSameColor.drawUnderline(true);
        this.buttonSelectSameColor.setEnabled(this.dotLabelScrollPane.getRootSlots().size() > 1);
        this.buttonSave = (Button)this.footerLayout.addChild((LayoutElement)new Button(this.labelSave, b -> this.save()));
        this.buttonSave.setWidth(this.font.width(this.labelSave) + 10);
        this.footerLayout.addChild((LayoutElement)Button.builder((Component)this.labelClose, b -> this.closeAndReturn()).width(this.font.width((FormattedText)this.labelClose) + 10).build());
        this.validate();
    }

    @Override
    protected void repositionElements() {
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        Objects.requireNonNull(this);
        this.dotLabelScrollPane.updateSize(this.width, this.height - 36 - 30 - this.buttonHeaderHeight, 0, 36 + this.buttonHeaderHeight);
        this.dotLabelScrollPane.setListWidth(this.panelWidth());
        this.dotLabelScrollPane.setScrollAmount(this.dotLabelScrollPane.getScrollAmount());
        super.repositionElements();
    }

    @Override
    public void render(GuiGraphics graphics, int x, int y, float partialTicks) {
        try {
            this.buttonSelectSameColor.setEnabled(this.dotLabelScrollPane.getRootSlots().size() > 1 && this.dotLabelScrollPane.getSelectedCount() == 1);
            super.render(graphics, x, y, partialTicks);
            Objects.requireNonNull(this);
            Objects.requireNonNull(this);
            this.outline(graphics, 0, 36, this.width - 1, this.height - 66);
            Objects.requireNonNull(this);
            DrawUtil.drawRectangle(graphics, 0.0, 36 + this.buttonHeaderHeight, this.width - 1, 1.0, 0xC0C0C0, 0.8f);
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Error during MobsAndPlayersColorEditor render: {}", (Object)LogFormatter.toPartialString(t));
            UIManager.INSTANCE.closeAll();
        }
    }

    private int panelWidth() {
        return Math.min(this.width, 480);
    }

    protected boolean validate() {
        boolean valid = false;
        for (DotLabelColorItem dotLabel : this.dotLabelScrollPane.getRootSlots()) {
            if (!dotLabel.isEdited()) continue;
            valid = true;
            break;
        }
        this.buttonSave.setEnabled(valid);
        return valid;
    }

    protected void save() {
        if (!this.validate()) {
            return;
        }
        for (DotLabelColorItem dotLabel : this.dotLabelScrollPane.getRootSlots()) {
            if (!dotLabel.isEdited()) continue;
            dotLabel.property.set(RGB.toHexString(dotLabel.color));
            dotLabel.property.save();
        }
        JourneymapClient.getInstance().getCoreProperties().clearMobColors();
        this.refreshAndClose();
    }

    private void buttonColorPickerPressed(DotLabelColorItem item) {
        if (!this.dotLabelScrollPane.isSelectedItem(item)) {
            this.dotLabelScrollPane.setSelected(item);
        }
    }

    private void selectOnly(DotLabelColorItem item) {
        this.dotLabelScrollPane.setSelected((Slot)null);
        this.dotLabelScrollPane.setSelected(item);
    }

    private void editColorsOfSelected(int color) {
        for (Slot slot : this.dotLabelScrollPane.getAllSelected()) {
            DotLabelColorItem dotLabel = (DotLabelColorItem)slot;
            dotLabel.setColor(color);
        }
        this.validate();
    }

    protected void refreshAndClose() {
        Fullscreen.state().requireRefresh();
        this.closeAndReturn();
    }

    static class DotLabelColorItem
    extends Slot {
        private final Font fontRenderer;
        private final String name;
        private final StringField property;
        private DynamicTexture textureBG = null;
        private DynamicTexture texture = null;
        private String label = null;
        private int color;
        private final int originalColor;
        private final MobsAndPlayersColorEditor editor;
        private final Button buttonDefault;
        private final Button buttonUndo;
        private final ColorPickerButton buttonColorPicker;
        private final List<GuiEventListener> children = new ArrayList<GuiEventListener>();
        private long lastClick = 0L;

        DotLabelColorItem(Font fontRenderer, String nameKey, StringField property, String label, MobsAndPlayersColorEditor editor) {
            this(fontRenderer, nameKey, property, null, null, label, editor);
        }

        DotLabelColorItem(Font fontRenderer, String nameKey, StringField property, @Nullable ResourceLocation textureBG, ResourceLocation texture, MobsAndPlayersColorEditor editor) {
            this(fontRenderer, nameKey, property, textureBG, texture, null, editor);
        }

        DotLabelColorItem(Font fontRenderer, String nameKey, StringField property, @Nullable ResourceLocation textureBG, @Nullable ResourceLocation texture, @Nullable String labelKey, MobsAndPlayersColorEditor editor) {
            this.fontRenderer = fontRenderer;
            this.name = Constants.getString(nameKey);
            this.property = property;
            if (textureBG != null) {
                this.textureBG = TextureCache.getTexture(textureBG);
            }
            if (texture != null) {
                this.texture = TextureCache.getTexture(texture);
            }
            if (labelKey != null) {
                this.label = Constants.getString(labelKey);
            }
            this.color = this.originalColor = JourneymapClient.getInstance().getCoreProperties().getColor(property);
            this.editor = editor;
            this.buttonDefault = new Button(Constants.getString("jm.colorpalette.default"), b -> this.resetColorToDefault());
            this.buttonDefault.fitWidth(fontRenderer);
            this.buttonUndo = new Button(Constants.getString("jm.colorpalette.undo"), b -> this.undoColor());
            this.buttonUndo.fitWidth(fontRenderer);
            this.buttonColorPicker = new ColorPickerButton(24, 24, () -> this.color, () -> false, this::colorPicked);
            this.children.add((GuiEventListener)this.buttonColorPicker);
            this.children.add((GuiEventListener)this.buttonUndo);
            this.children.add((GuiEventListener)this.buttonDefault);
        }

        private void colorPicked(ColorPickerScreen.ColorPickerResponse response) {
            if (response.canceled()) {
                return;
            }
            this.editor.editColorsOfSelected(response.color());
        }

        public void setColor(int color) {
            this.color = color;
        }

        private void resetColorToDefault() {
            this.color = RGB.hexToInt(this.property.getDefaultValue());
            this.editor.validate();
        }

        private void undoColor() {
            this.color = this.originalColor;
            this.editor.validate();
        }

        public boolean isEdited() {
            return this.color != this.originalColor;
        }

        public Collection<SlotMetadata> getMetadata() {
            return null;
        }

        public boolean mouseClicked(double mouseX, double mouseY, int mouseEvent) {
            try {
                if (this.buttonColorPicker.mouseClicked(mouseX, mouseY, mouseEvent)) {
                    this.editor.buttonColorPickerPressed(this);
                    return false;
                }
                if (this.buttonDefault.mouseClicked(mouseX, mouseY, mouseEvent)) {
                    return true;
                }
                if (this.buttonUndo.mouseClicked(mouseX, mouseY, mouseEvent)) {
                    return true;
                }
                if (mouseEvent == 0) {
                    long sysTime = Util.getMillis();
                    boolean doubleClick = sysTime - this.lastClick < 200L;
                    this.lastClick = sysTime;
                    if (doubleClick) {
                        this.buttonColorPicker.onPress();
                        this.editor.selectOnly(this);
                        return false;
                    }
                }
                this.editor.changeFocus(ComponentPath.path((ContainerEventHandler)this, (ComponentPath)ComponentPath.leaf((GuiEventListener)this.buttonColorPicker)));
                return true;
            }
            catch (Exception e) {
                Journeymap.getLogger().error("WARNING: Problem with mouseClicked.");
                throw new RuntimeException("mouseClicked", e);
            }
        }

        public List<? extends Slot> getChildSlots(int listWidth, int columnWidth) {
            return null;
        }

        public SlotMetadata getLastPressed() {
            return null;
        }

        public SlotMetadata getCurrentTooltip() {
            return null;
        }

        @Override
        public void setEnabled(boolean enabled) {
        }

        @Override
        public int getColumnWidth() {
            return 0;
        }

        public boolean contains(SlotMetadata slotMetadata) {
            return false;
        }

        public void render(GuiGraphics graphics, int slotIndex, int y, int x, int rowWidth, int itemHeight, int mouseX, int mouseY, boolean isMouseOver, float partialTicks) {
            graphics.fill(x, y, x + rowWidth - 4, y + itemHeight, -13619152);
            int xName = 80;
            if (this.label != null) {
                int xLabel = x + xName / 2;
                int yLabel = y + itemHeight / 2;
                DrawUtil.drawLabel(graphics, this.label, xLabel, yLabel, DrawUtil.HAlign.Center, DrawUtil.VAlign.Middle, 0, 1.0f, this.color, 1.0f, 1.0, false);
            } else {
                float scale = 0.2f;
                double xTex = (float)x + ((float)xName - (float)((TextureAccess)this.texture).journeymap$getWidth() * scale) / 2.0f;
                double yTex = (float)y + ((float)itemHeight - (float)((TextureAccess)this.texture).journeymap$getHeight() * scale) / 2.0f;
                graphics.flush();
                if (this.textureBG != null) {
                    DrawUtil.drawColoredImage(graphics, this.textureBG, 0xFFFFFF, 1.0f, xTex, yTex, scale, 225.0);
                }
                DrawUtil.drawColoredImage(graphics, this.texture, this.color, 1.0f, xTex, yTex, scale, 225.0);
            }
            Objects.requireNonNull(this.fontRenderer);
            graphics.drawString(this.fontRenderer, this.name, x + xName, y + (itemHeight - 9) / 2, -1, true);
            this.buttonDefault.leftOf(x + rowWidth - 32);
            this.buttonDefault.below(y + 3);
            this.buttonDefault.render(graphics, mouseX, mouseY, partialTicks);
            this.buttonUndo.setVisible(this.isEdited());
            this.buttonUndo.leftOf(x + rowWidth - 34 - this.buttonDefault.getWidth());
            this.buttonUndo.below(y + 3);
            this.buttonUndo.render(graphics, mouseX, mouseY, partialTicks);
            if (isMouseOver || this.isFocused()) {
                this.buttonColorPicker.leftOf(x + rowWidth - 5);
                this.buttonColorPicker.below(y + 1);
                this.buttonColorPicker.render(graphics, mouseX, mouseY, partialTicks);
            }
        }

        @Override
        public List<? extends GuiEventListener> children() {
            return this.children;
        }
    }
}

