/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.mixin.world.inline_block_access;

import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={Level.class})
public abstract class LevelMixin
implements LevelHeightAccessor {
    private static final BlockState OUTSIDE_WORLD_BLOCK = Blocks.VOID_AIR.defaultBlockState();
    private static final BlockState INSIDE_WORLD_DEFAULT_BLOCK = Blocks.AIR.defaultBlockState();

    @Shadow
    public abstract LevelChunk getChunk(int var1, int var2);

    @Overwrite
    public BlockState getBlockState(BlockPos pos) {
        LevelChunk worldChunk = this.getChunk(SectionPos.blockToSectionCoord((int)pos.getX()), SectionPos.blockToSectionCoord((int)pos.getZ()));
        LevelChunkSection[] sections = worldChunk.getSections();
        int x = pos.getX();
        int y = pos.getY();
        int z = pos.getZ();
        int chunkY = this.getSectionIndex(y);
        if (chunkY < 0 || chunkY >= sections.length || worldChunk.isEmpty()) {
            return OUTSIDE_WORLD_BLOCK;
        }
        LevelChunkSection section = sections[chunkY];
        if (section == null || section.hasOnlyAir()) {
            return INSIDE_WORLD_DEFAULT_BLOCK;
        }
        return section.getBlockState(x & 0xF, y & 0xF, z & 0xF);
    }

    @Redirect(method={"getFluidState"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;isOutsideBuildHeight(Lnet/minecraft/core/BlockPos;)Z"))
    private boolean skipFluidHeightLimitTest(Level world, BlockPos pos) {
        return world.isOutsideBuildHeight(pos);
    }
}

