/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.lithium.neoforge;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.caffeinemc.mods.lithium.common.config.Option;
import net.caffeinemc.mods.lithium.common.services.PlatformMixinOverrides;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.fml.loading.moddiscovery.ModInfo;

public class NeoForgeMixinOverrides
implements PlatformMixinOverrides {
    protected static final String JSON_KEY_LITHIUM_OPTIONS = "lithium:options";

    @Override
    public void applyLithiumCompat(Map<String, Option> options) {
    }

    @Override
    public List<PlatformMixinOverrides.MixinOverride> applyModOverrides() {
        ArrayList<PlatformMixinOverrides.MixinOverride> list = new ArrayList<PlatformMixinOverrides.MixinOverride>();
        for (ModInfo meta : FMLLoader.getLoadingModList().getMods()) {
            meta.getOwningFile().getConfigElement(new String[]{JSON_KEY_LITHIUM_OPTIONS}).ifPresent(override -> {
                Map overrides;
                if (override instanceof Map && (overrides = (Map)override).keySet().stream().allMatch(key -> key instanceof String)) {
                    overrides.forEach((key, value) -> {
                        if (!(value instanceof Boolean) || !(key instanceof String)) {
                            System.out.printf("[Lithium] Mod '%s' attempted to override option '%s' with an invalid value, ignoring", meta.getModId(), key);
                            return;
                        }
                        list.add(new PlatformMixinOverrides.MixinOverride(meta.getModId(), (String)key, (Boolean)value));
                    });
                } else {
                    System.out.printf("[Lithium] '%s' contains invalid Lithium option overrides, ignoring", meta.getModId());
                }
            });
        }
        return list;
    }
}

