/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.renderer;

import com.seibel.distanthorizons.api.interfaces.override.rendering.IDhApiShaderProgram;
import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiRenderParam;
import com.seibel.distanthorizons.api.objects.math.DhApiVec3f;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import com.seibel.distanthorizons.core.render.glObject.shader.Shader;
import com.seibel.distanthorizons.core.render.glObject.shader.ShaderProgram;
import com.seibel.distanthorizons.core.render.glObject.vertexAttribute.AbstractVertexAttribute;
import com.seibel.distanthorizons.core.render.glObject.vertexAttribute.VertexAttributePostGL43;
import com.seibel.distanthorizons.core.render.glObject.vertexAttribute.VertexAttributePreGL43;
import com.seibel.distanthorizons.core.render.glObject.vertexAttribute.VertexPointer;
import com.seibel.distanthorizons.core.util.LodUtil;
import com.seibel.distanthorizons.core.util.RenderUtil;
import com.seibel.distanthorizons.core.util.math.Mat4f;
import com.seibel.distanthorizons.core.util.math.Vec3f;

public class DhTerrainShaderProgram
extends ShaderProgram
implements IDhApiShaderProgram {
    public final AbstractVertexAttribute vao;
    public int uCombinedMatrix = this.getUniformLocation("uCombinedMatrix");
    public int uModelOffset = this.getUniformLocation("uModelOffset");
    public int uWorldYOffset = this.tryGetUniformLocation("uWorldYOffset");
    public int uDitherDhRendering = this.tryGetUniformLocation("uDitherDhRendering");
    public int uMircoOffset = this.getUniformLocation("uMircoOffset");
    public int uEarthRadius = this.tryGetUniformLocation("uEarthRadius");
    public int uLightMap = this.getUniformLocation("uLightMap");
    public int uClipDistance = this.getUniformLocation("uClipDistance");
    public int uNoiseEnabled = this.getUniformLocation("uNoiseEnabled");
    public int uNoiseSteps = this.getUniformLocation("uNoiseSteps");
    public int uNoiseIntensity = this.getUniformLocation("uNoiseIntensity");
    public int uNoiseDropoff = this.getUniformLocation("uNoiseDropoff");
    public int uIsWhiteWorld = this.getUniformLocation("uIsWhiteWorld");

    public DhTerrainShaderProgram() {
        super(() -> Shader.loadFile(Config.Client.Advanced.Graphics.Experimental.earthCurveRatio.get() != 0 ? "shaders/curve.vert" : "shaders/standard.vert", false, new StringBuilder()).toString(), () -> Shader.loadFile("shaders/flat_shaded.frag", false, new StringBuilder()).toString(), "fragColor", new String[]{"vPosition", "color"});
        int vertexByteCount = LodUtil.LOD_VERTEX_FORMAT.getByteSize();
        this.vao = GLProxy.getInstance().vertexAttributeBufferBindingSupported ? new VertexAttributePostGL43() : new VertexAttributePreGL43();
        this.vao.bind();
        this.vao.setVertexAttribute(0, 0, VertexPointer.addUnsignedShortsPointer(4, false, true));
        this.vao.setVertexAttribute(0, 1, VertexPointer.addUnsignedBytesPointer(4, true, false));
        this.vao.setVertexAttribute(0, 2, VertexPointer.addUnsignedBytesPointer(4, true, true));
        try {
            this.vao.completeAndCheck(vertexByteCount);
        }
        catch (RuntimeException e) {
            System.out.println(LodUtil.LOD_VERTEX_FORMAT);
            throw e;
        }
    }

    @Override
    public void bind() {
        super.bind();
        this.vao.bind();
    }

    @Override
    public void unbind() {
        super.unbind();
        this.vao.unbind();
    }

    @Override
    public void free() {
        this.vao.free();
        super.free();
    }

    @Override
    public void bindVertexBuffer(int vbo) {
        this.vao.bindBufferToAllBindingPoints(vbo);
    }

    @Override
    public void fillUniformData(DhApiRenderParam renderParameters) {
        Mat4f combinedMatrix = new Mat4f(renderParameters.dhProjectionMatrix);
        combinedMatrix.multiply(renderParameters.dhModelViewMatrix);
        super.bind();
        this.setUniform(this.uCombinedMatrix, combinedMatrix);
        this.setUniform(this.uMircoOffset, 0.01f);
        this.setUniform(this.uLightMap, 0);
        if (this.uWorldYOffset != -1) {
            this.setUniform(this.uWorldYOffset, (float)renderParameters.worldYOffset);
        }
        if (this.uDitherDhRendering != -1) {
            this.setUniform(this.uDitherDhRendering, Config.Client.Advanced.Graphics.Quality.ditherDhFade.get());
        }
        if (this.uEarthRadius != -1) {
            this.setUniform(this.uEarthRadius, 6371000.0f / (float)Config.Client.Advanced.Graphics.Experimental.earthCurveRatio.get().intValue());
        }
        this.setUniform(this.uNoiseEnabled, Config.Client.Advanced.Graphics.NoiseTexture.enableNoiseTexture.get());
        this.setUniform(this.uNoiseSteps, Config.Client.Advanced.Graphics.NoiseTexture.noiseSteps.get());
        this.setUniform(this.uNoiseIntensity, Config.Client.Advanced.Graphics.NoiseTexture.noiseIntensity.get().floatValue());
        this.setUniform(this.uNoiseDropoff, Config.Client.Advanced.Graphics.NoiseTexture.noiseDropoff.get());
        this.setUniform(this.uIsWhiteWorld, Config.Client.Advanced.Debugging.enableWhiteWorld.get());
        float dhNearClipDistance = RenderUtil.getNearClipPlaneInBlocksForFading(renderParameters.partialTicks);
        if (!Config.Client.Advanced.Debugging.lodOnlyMode.get().booleanValue()) {
            dhNearClipDistance += 16.0f;
        }
        if (RenderUtil.getHeightBasedNearClipOverride() != -1.0f) {
            dhNearClipDistance = 1.0f;
        }
        this.setUniform(this.uClipDistance, dhNearClipDistance);
    }

    @Override
    public void setModelOffsetPos(DhApiVec3f modelOffsetPos) {
        this.setUniform(this.uModelOffset, new Vec3f(modelOffsetPos));
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public boolean overrideThisFrame() {
        return true;
    }
}

