/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.bulk_fermenter;

import com.jesz.createdieselgenerators.CDGBlockEntityTypes;
import com.jesz.createdieselgenerators.content.bulk_fermenter.BulkFermenterBlockEntity;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.item.ItemHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.util.DeferredSoundType;
import net.neoforged.neoforge.items.IItemHandler;

public class BulkFermenterBlock
extends Block
implements IBE<BulkFermenterBlockEntity>,
IWrenchable {
    public static final SoundType SILENCED_METAL = new DeferredSoundType(0.1f, 1.5f, () -> SoundEvents.METAL_BREAK, () -> SoundEvents.METAL_STEP, () -> SoundEvents.METAL_PLACE, () -> SoundEvents.METAL_HIT, () -> SoundEvents.METAL_FALL);

    public BulkFermenterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighbourState, LevelAccessor level, BlockPos pos, BlockPos neighbourPos) {
        if (direction == Direction.DOWN && neighbourState.getBlock() != this) {
            this.withBlockEntityDo((BlockGetter)level, pos, BulkFermenterBlockEntity::updateHeat);
        }
        return super.updateShape(state, direction, neighbourState, level, pos, neighbourPos);
    }

    public void onPlace(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean moved) {
        if (oldState.getBlock() == state.getBlock()) {
            return;
        }
        if (moved) {
            return;
        }
        this.withBlockEntityDo((BlockGetter)world, pos, BulkFermenterBlockEntity::updateConnectivity);
        this.withBlockEntityDo((BlockGetter)world, pos, BulkFermenterBlockEntity::updateHeat);
    }

    public void onRemove(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.hasBlockEntity() && (state.getBlock() != newState.getBlock() || !newState.hasBlockEntity())) {
            BlockEntity be = world.getBlockEntity(pos);
            if (!(be instanceof BulkFermenterBlockEntity)) {
                return;
            }
            BulkFermenterBlockEntity tankBE = (BulkFermenterBlockEntity)be;
            ItemHelper.dropContents((Level)world, (BlockPos)pos, (IItemHandler)tankBE.inventory);
            world.removeBlockEntity(pos);
            ConnectivityHandler.splitMulti((BlockEntity)tankBE);
        }
    }

    public Class<BulkFermenterBlockEntity> getBlockEntityClass() {
        return BulkFermenterBlockEntity.class;
    }

    public BlockEntityType<? extends BulkFermenterBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CDGBlockEntityTypes.BULK_FERMENTER.get();
    }

    public SoundType getSoundType(BlockState state, LevelReader world, BlockPos pos, Entity entity) {
        SoundType soundType = super.getSoundType(state, world, pos, entity);
        if (entity != null && entity.getPersistentData().contains("SilenceTankSound")) {
            return SILENCED_METAL;
        }
        return soundType;
    }
}

