/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.tools;

import com.jesz.createdieselgenerators.CDGEntityTypes;
import com.jesz.createdieselgenerators.CDGRegistries;
import com.jesz.createdieselgenerators.fuel_type.FuelType;
import com.simibubi.create.AllFluids;
import com.simibubi.create.content.fluids.FluidFX;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.BlockHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractHurtingProjectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.EffectCures;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidStack;

public class ChemicalSprayerProjectileEntity
extends AbstractHurtingProjectile {
    public FluidStack stack;
    public boolean fire;
    public boolean cooling;
    int t = 0;
    static final EntityDataAccessor<CompoundTag> DATA = SynchedEntityData.defineId(ChemicalSprayerProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.COMPOUND_TAG);

    public ChemicalSprayerProjectileEntity(EntityType<? extends AbstractHurtingProjectile> type, Level level) {
        super(type, level);
    }

    public static ChemicalSprayerProjectileEntity spray(Level level, FluidStack stack, boolean fire, boolean cooling) {
        ChemicalSprayerProjectileEntity projectile = new ChemicalSprayerProjectileEntity((EntityType<? extends AbstractHurtingProjectile>)((EntityType)CDGEntityTypes.CHEMICAL_SPRAYER_PROJECTILE.get()), level);
        projectile.stack = stack;
        projectile.fire = fire;
        projectile.cooling = cooling;
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("Fire", fire);
        tag.putBoolean("Cooling", cooling);
        tag.put("FluidStack", stack.save((HolderLookup.Provider)level.registryAccess(), (Tag)new CompoundTag()));
        projectile.getEntityData().set(DATA, (Object)tag);
        return projectile;
    }

    protected void onHitEntity(EntityHitResult hit) {
        Entity owner = this.getOwner();
        if (this.fire) {
            hit.getEntity().setRemainingFireTicks(hit.getEntity().getRemainingFireTicks() + 100);
            hit.getEntity().hurt(this.damageSources().inFire(), 2.0f);
        } else if (this.cooling) {
            hit.getEntity().clearFire();
            if (hit.getEntity().getType() == EntityType.ENDERMAN) {
                hit.getEntity().hurt(this.damageSources().generic(), 0.5f);
            }
        } else if (this.stack.getFluid().isSame((Fluid)AllFluids.POTION.get())) {
            PotionContents potionContents;
            LivingEntity le;
            Entity entity = hit.getEntity();
            if (entity instanceof LivingEntity && (le = (LivingEntity)entity).isAffectedByPotions() && (potionContents = (PotionContents)this.stack.get(DataComponents.POTION_CONTENTS)) != null) {
                for (MobEffectInstance effectInstance : potionContents.getAllEffects()) {
                    MobEffect effect = (MobEffect)effectInstance.getEffect().value();
                    if (effect.isInstantenous()) {
                        effect.applyInstantenousEffect(owner, owner, le, effectInstance.getAmplifier(), 0.5);
                        continue;
                    }
                    le.addEffect(new MobEffectInstance(effectInstance), owner);
                }
            }
        } else if (FluidHelper.isTag((FluidStack)this.stack, (TagKey)Tags.Fluids.MILK)) {
            LivingEntity le;
            Entity entity = hit.getEntity();
            if (entity instanceof LivingEntity && (le = (LivingEntity)entity).isAffectedByPotions()) {
                le.removeEffectsCuredBy(EffectCures.MILK);
            }
        } else {
            if (owner instanceof LivingEntity) {
                ((LivingEntity)owner).setLastHurtMob(hit.getEntity());
            }
            hit.getEntity().hurt(this.damageSources().generic(), 0.5f);
        }
        super.onHitEntity(hit);
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    public void load(CompoundTag compound) {
        if (this.stack == null) {
            this.stack = FluidStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)compound.getCompound("FluidStack"));
        }
        super.load(compound);
    }

    public CompoundTag saveWithoutId(CompoundTag compound) {
        if (this.stack != null) {
            this.stack.save((HolderLookup.Provider)this.level().registryAccess(), (Tag)compound.getCompound("FluidStack"));
        }
        return super.saveWithoutId(compound);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        CompoundTag tag = new CompoundTag();
        tag.putBoolean("Fire", this.fire);
        tag.putBoolean("Cooling", this.cooling);
        builder.define(DATA, (Object)tag);
    }

    public void tick() {
        if (this.level().isClientSide) {
            this.stack = FluidStack.parseOptional((HolderLookup.Provider)this.level().registryAccess(), (CompoundTag)((CompoundTag)this.getEntityData().get(DATA)).getCompound("FluidStack"));
            this.fire = ((CompoundTag)this.getEntityData().get(DATA)).getBoolean("Fire");
            this.cooling = ((CompoundTag)this.getEntityData().get(DATA)).getBoolean("Cooling");
            if (this.stack != null && !this.stack.isEmpty() && !this.fire) {
                this.level().addParticle(FluidFX.getFluidParticle((FluidStack)this.stack), this.position().x + this.random.nextDouble() - 0.5, this.position().y + 0.3, this.position().z + this.random.nextDouble() - 0.5, this.getDeltaMovement().x, this.getDeltaMovement().y - 0.1, this.getDeltaMovement().z);
            }
            if (this.t >= 1) {
                if (this.fire) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.LAVA, this.position().x, this.position().y, this.position().z, this.getDeltaMovement().x, this.getDeltaMovement().y - 0.1, this.getDeltaMovement().z);
                }
                this.t = 0;
            } else {
                ++this.t;
            }
        }
        this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.015, 0.0));
        if (this.fire) {
            boolean flammable;
            Fluid fluid = this.level().getFluidState(BlockPos.containing((Position)this.position())).getType();
            boolean bl = flammable = FuelType.getTypeFor((HolderLookup.RegistryLookup<FuelType>)this.level().registryAccess().lookupOrThrow(CDGRegistries.FUEL_TYPE), fluid).normal().speed() != 0.0f;
            if (flammable) {
                this.level().explode(null, this.getX(), this.getY(), this.getZ(), 3.0f, Level.ExplosionInteraction.BLOCK);
            } else if (this.level().getFluidState(new BlockPos((int)this.getPosition((float)1.0f).x, (int)this.getPosition((float)1.0f).y, (int)this.getPosition((float)1.0f).z)).is((Fluid)Fluids.FLOWING_WATER) || this.level().getFluidState(new BlockPos((int)this.getPosition((float)1.0f).x, (int)this.getPosition((float)1.0f).y, (int)this.getPosition((float)1.0f).z)).is((Fluid)Fluids.WATER)) {
                this.fire = false;
                if (this.stack.getFluid().isSame((Fluid)Fluids.LAVA)) {
                    this.remove(Entity.RemovalReason.DISCARDED);
                }
                ((CompoundTag)this.getEntityData().get(DATA)).putBoolean("Fire", false);
            }
        }
        Entity entity = this.getOwner();
        if (this.level().isClientSide || (entity == null || !entity.isRemoved()) && this.level().hasChunkAt(this.blockPosition())) {
            HitResult hitresult;
            if (this.shouldBurn()) {
                this.setRemainingFireTicks(1);
            }
            if ((hitresult = ProjectileUtil.getHitResultOnMoveVector((Entity)this, x$0 -> this.canHitEntity((Entity)x$0))).getType() != HitResult.Type.MISS) {
                this.onHit(hitresult);
            }
            this.checkInsideBlocks();
            ProjectileUtil.rotateTowardsMovement((Entity)this, (float)0.2f);
            Vec3 deltaMovement = this.getDeltaMovement();
            double pX = this.getX() + deltaMovement.x;
            double pY = this.getY() + deltaMovement.y;
            double pZ = this.getZ() + deltaMovement.z;
            this.setPos(pX, pY, pZ);
            float inertia = this.getInertia();
            if (this.isInWater()) {
                inertia = 0.8f;
            }
            this.setDeltaMovement(deltaMovement.scale((double)inertia));
        } else {
            this.discard();
        }
    }

    public boolean isOnFire() {
        return this.fire;
    }

    protected void onHitBlock(BlockHitResult hit) {
        super.onHitBlock(hit);
        BlockPos pos = new BlockPos((int)Math.floor(this.getPosition((float)1.0f).x), (int)Math.floor(this.getPosition((float)1.0f).y), (int)Math.floor(this.getPosition((float)1.0f).z));
        if (this.cooling) {
            if (this.level().getBlockState(pos).getBlock() instanceof FireBlock) {
                this.level().setBlock(pos, Blocks.AIR.defaultBlockState(), 3);
                this.level().playLocalSound(this.position().x, this.position().y, this.position().z, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.0f, true);
            }
            for (int i = 0; i < 6; ++i) {
                if (!(this.level().getBlockState(pos.relative(Direction.values()[i], 1)).getBlock() instanceof FireBlock)) continue;
                this.level().setBlock(pos.relative(Direction.values()[i], 1), Blocks.AIR.defaultBlockState(), 3);
                this.level().playLocalSound(this.position().x, this.position().y, this.position().z, SoundEvents.FIRE_EXTINGUISH, SoundSource.BLOCKS, 0.5f, 2.0f, true);
            }
        }
        if (this.fire && this.level().getBlockState(pos).getBlock() instanceof AirBlock && BlockHelper.hasBlockSolidSide((BlockState)this.level().getBlockState(pos.below()), (BlockGetter)this.level(), (BlockPos)pos.below(), (Direction)Direction.UP)) {
            this.level().setBlock(pos, FireBlock.getState((BlockGetter)this.level(), (BlockPos)pos), 3);
        }
        this.remove(Entity.RemovalReason.DISCARDED);
    }

    public float getPickRadius() {
        return 0.0f;
    }
}

