/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.mixins;

import com.jesz.createdieselgenerators.CDGItems;
import com.jesz.createdieselgenerators.content.molds.MoldItemRenderer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.processing.basin.BasinBlockEntity;
import com.simibubi.create.content.processing.basin.BasinRenderer;
import java.util.LinkedList;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={BasinRenderer.class})
public abstract class BasinRendererMixin {
    @Shadow
    protected abstract void renderItem(PoseStack var1, MultiBufferSource var2, int var3, int var4, ItemStack var5);

    @Inject(method={"renderItem"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    public void renderItem(PoseStack ms, MultiBufferSource buffer, int light, int overlay, ItemStack stack, CallbackInfo ci) {
        if (!CDGItems.MOLD.isIn(stack)) {
            return;
        }
        MoldItemRenderer.renderInBasin(ms, buffer, light, overlay, stack);
        ci.cancel();
    }

    @Inject(method={"renderSafe(Lcom/simibubi/create/content/processing/basin/BasinBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    public void renderSafe(BasinBlockEntity basin, float partialTicks, PoseStack ms, MultiBufferSource buffer, int light, int overlay, CallbackInfo ci) {
        IItemHandler inv = (IItemHandler)basin.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, basin.getBlockPos(), null);
        if (inv == null) {
            return;
        }
        LinkedList<ItemStack> items = new LinkedList<ItemStack>();
        boolean hasMold = false;
        for (int slot = 0; slot < inv.getSlots(); ++slot) {
            ItemStack stack = inv.getStackInSlot(slot);
            items.add(stack);
            if (!CDGItems.MOLD.isIn(stack)) continue;
            hasMold = true;
        }
        if (!hasMold) {
            return;
        }
        MoldItemRenderer.renderItemsOnMold(basin, ms, buffer, light, overlay, items, partialTicks);
        ci.cancel();
    }
}

