/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.world;

import com.jesz.createdieselgenerators.CDGConfig;
import com.jesz.createdieselgenerators.CreateDieselGenerators;
import com.jesz.createdieselgenerators.compat.kubejs.CDGKubeJSPlugin;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.createmod.catnip.nbt.NBTHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.synth.PerlinNoise;
import net.minecraft.world.level.saveddata.SavedData;
import net.neoforged.fml.ModList;

public class OilChunksSavedData
extends SavedData {
    Map<ChunkPos, Integer> chunks = new HashMap<ChunkPos, Integer>();
    ServerLevel level;

    public CompoundTag save(CompoundTag compound, HolderLookup.Provider registries) {
        ListTag lt = new ListTag();
        this.chunks.forEach((pos, amount) -> {
            CompoundTag c = new CompoundTag();
            c.put("x", (Tag)IntTag.valueOf((int)pos.x));
            c.put("z", (Tag)IntTag.valueOf((int)pos.z));
            c.put("Amountmb", (Tag)IntTag.valueOf((int)amount));
            lt.add((Object)c);
        });
        compound.put("OilChunks", (Tag)lt);
        return compound;
    }

    private OilChunksSavedData(ServerLevel level) {
        this.level = level;
    }

    private static OilChunksSavedData load(ServerLevel level, CompoundTag tag, HolderLookup.Provider registries) {
        OilChunksSavedData sd = new OilChunksSavedData(level);
        sd.chunks = new HashMap<ChunkPos, Integer>();
        NBTHelper.iterateCompoundList((ListTag)tag.getList("OilChunks", 10), c -> sd.chunks.put(new ChunkPos(c.getInt("x"), c.getInt("z")), c.contains("Amountmb") ? c.getInt("Amountmb") : c.getInt("Amount") * 1000));
        return sd;
    }

    public static OilChunksSavedData load(ServerLevel level) {
        return (OilChunksSavedData)level.getDataStorage().computeIfAbsent(new SavedData.Factory(() -> new OilChunksSavedData(level), (compoundTag, provider) -> OilChunksSavedData.load(level, compoundTag, provider)), "cdg_oil_chunks");
    }

    public void setChunkAmount(ChunkPos chunk, int amount) {
        if (this.chunks.containsKey(chunk)) {
            this.chunks.replace(chunk, amount);
        } else {
            this.chunks.put(chunk, amount);
        }
        this.setDirty();
    }

    public void removeChunk(ChunkPos chunk) {
        this.chunks.remove(chunk);
        this.setDirty();
    }

    public int getChunkOilAmount(ChunkPos chunk) {
        if (this.chunks.containsKey(chunk)) {
            return this.chunks.get(chunk) > (Integer)CDGConfig.OIL_CHUNK_INFINITE_THRESHOLD.get() ? Integer.MAX_VALUE : this.chunks.get(chunk);
        }
        return OilChunksSavedData.getBaseOilAmount(this.level, chunk);
    }

    public static int getChunkOilAmount(ServerLevel level, ChunkPos chunk) {
        return OilChunksSavedData.load(level).getChunkOilAmount(chunk);
    }

    public static void setChunkOilAmount(ServerLevel level, ChunkPos chunk, int amount) {
        OilChunksSavedData.load(level).setChunkAmount(chunk, amount);
    }

    public static void removeChunk(ServerLevel level, ChunkPos chunk) {
        OilChunksSavedData.load(level).removeChunk(chunk);
    }

    public static int getBaseOilAmount(ServerLevel level, ChunkPos chunk) {
        int amount;
        long seed = level.getSeed();
        List<Holder<Biome>> biomes = OilChunksSavedData.getBiomesInChunk(level, chunk);
        if (ModList.get().isLoaded("kubejs") && (amount = CDGKubeJSPlugin.calculateOilChunks(biomes, chunk, seed)) != -1) {
            return amount;
        }
        double scale = (Double)CDGConfig.OIL_CHUNK_SCALE.get();
        PerlinNoise noise = PerlinNoise.create((RandomSource)RandomSource.create((long)seed), List.of(Integer.valueOf(-2), Integer.valueOf(-1), Integer.valueOf(0), Integer.valueOf(1)));
        float amount2 = (float)(noise.getValue((double)chunk.x * scale, 0.0, (double)chunk.z * scale) + 1.0) / 1.6f;
        boolean isHighInOil = false;
        boolean isDenied = false;
        for (Holder<Biome> biome : biomes) {
            if (biome.is(TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CreateDieselGenerators.rl("oil_biomes")))) {
                isHighInOil = true;
            }
            if (!biome.is(TagKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)CreateDieselGenerators.rl("deny_oil_biomes")))) continue;
            isDenied = true;
        }
        if (isDenied) {
            return 0;
        }
        int max = (int)(7000000.0 * (Double)CDGConfig.OIL_MULTIPLIER.get());
        if (isHighInOil) {
            max = (int)(7000000.0 * (Double)CDGConfig.HIGH_OIL_MULTIPLIER.get());
        }
        amount2 = (float)Math.pow(amount2, 2.0);
        if ((amount2 *= (float)max) < (float)((Integer)CDGConfig.OIL_CHUNK_THRESHOLD.get()).intValue()) {
            return 0;
        }
        if (amount2 > (float)((Integer)CDGConfig.OIL_CHUNK_INFINITE_THRESHOLD.get()).intValue()) {
            return Integer.MAX_VALUE;
        }
        return (int)amount2;
    }

    public static List<Holder<Biome>> getBiomesInChunk(ServerLevel level, ChunkPos chunkPos) {
        ArrayList<Holder<Biome>> list = new ArrayList<Holder<Biome>>();
        for (int x = chunkPos.getMinBlockX(); x <= chunkPos.getMaxBlockX(); ++x) {
            for (int y = 60; y < 110; ++y) {
                for (int z = chunkPos.getMinBlockZ(); z <= chunkPos.getMaxBlockZ(); ++z) {
                    Holder biome = level.getBiome(new BlockPos(x, y, z));
                    if (list.contains(biome)) continue;
                    list.add((Holder<Biome>)biome);
                }
            }
        }
        return list;
    }
}

