/*
 * Decompiled with CFR 0.152.
 */
package com.robocraft999.creategoggles.item.goggle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.robocraft999.creategoggles.CGConfig;
import com.robocraft999.creategoggles.compat.CuriosCompatDummy;
import com.robocraft999.creategoggles.item.goggle.IGoggleHelmet;
import com.simibubi.create.AllItems;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class GoggleArmorLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    public GoggleArmorLayer(RenderLayerParent<T, M> renderer) {
        super(renderer);
    }

    public void render(PoseStack ms, MultiBufferSource buffer, int light, LivingEntity entity, float yaw, float pitch, float pt, float p_117356_, float p_117357_, float p_117358_) {
        if (entity.getPose() == Pose.SLEEPING) {
            return;
        }
        if (!IGoggleHelmet.isGoggleHelmet(entity) || CuriosCompatDummy.predicate.test(entity)) {
            return;
        }
        EntityModel entityModel = this.getParentModel();
        if (!(entityModel instanceof HumanoidModel)) {
            return;
        }
        HumanoidModel model = (HumanoidModel)entityModel;
        ItemStack stack = new ItemStack((ItemLike)AllItems.GOGGLES.get());
        ms.pushPose();
        ms.translate((double)model.head.x / 16.0, (double)model.head.y / 16.0, (double)model.head.z / 16.0);
        ms.mulPose(Axis.YP.rotation(model.head.yRot));
        ms.mulPose(Axis.XP.rotation(model.head.xRot));
        ms.translate(0.0, -0.25, -0.05);
        ms.mulPose(Axis.ZP.rotationDegrees(180.0f));
        ms.scale(0.625f, 0.625f, 0.625f);
        if (((Boolean)CGConfig.CLIENT.moveGoggleToEyes.get()).booleanValue()) {
            ms.mulPose(Axis.ZP.rotationDegrees(180.0f));
            ms.translate(0.0, -0.25, 0.0);
        }
        Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.HEAD, light, OverlayTexture.NO_OVERLAY, ms, buffer, (Level)Minecraft.getInstance().level, 0);
        ms.popPose();
    }
}

