/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.client.render.entity.model;

import aqario.fowlplay.client.render.entity.animation.CrowAnimations;
import aqario.fowlplay.client.render.entity.model.FlyingBirdModel;
import aqario.fowlplay.common.entity.CrowEntity;
import aqario.fowlplay.core.FowlPlay;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;

public class CrowModel
extends FlyingBirdModel<CrowEntity> {
    public static final ModelLayerLocation MODEL_LAYER = new ModelLayerLocation(FowlPlay.id("crow"), "main");

    public CrowModel(ModelPart root) {
        super(root);
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition modelData = new MeshDefinition();
        PartDefinition modelPartData = modelData.getRoot();
        PartDefinition root = modelPartData.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)21.0f, (float)-1.0f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.25f, (float)1.0f));
        PartDefinition neck = body.addOrReplaceChild("neck", CubeListBuilder.create().texOffs(0, 14).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(-0.001f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)-2.75f));
        PartDefinition head = neck.addOrReplaceChild("head", CubeListBuilder.create().texOffs(0, 9).addBox(-1.0f, -3.0f, -1.0f, 2.0f, 3.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-2.0f, (float)0.0f));
        head.addOrReplaceChild("beak", CubeListBuilder.create().texOffs(0, 0).addBox(-0.5f, -0.5f, -1.5f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.offset((float)0.0f, (float)-1.5f, (float)-1.0f));
        body.addOrReplaceChild("torso", CubeListBuilder.create().texOffs(0, 0).addBox(-1.5f, -2.0f, -4.0f, 3.0f, 3.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.75f, (float)0.0f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("left_wing", CubeListBuilder.create().texOffs(10, 7).addBox(-1.5f, -1.0f, -0.5f, 2.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.5f, (float)-3.25f, (float)-2.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        body.addOrReplaceChild("right_wing", CubeListBuilder.create().texOffs(10, 7).mirror().addBox(-0.5f, -1.0f, -0.5f, 2.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.5f, (float)-3.25f, (float)-2.0f, (float)-0.3927f, (float)0.0f, (float)0.0f));
        PartDefinition left_wing_open = body.addOrReplaceChild("left_wing_open", CubeListBuilder.create().texOffs(0, 19).addBox(-0.5f, 0.0f, -1.0f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-3.75f, (float)-1.5f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        left_wing_open.addOrReplaceChild("left_wing_outer", CubeListBuilder.create().texOffs(-6, 26).addBox(0.0f, 0.0f, 0.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.offset((float)5.5f, (float)0.0f, (float)-1.0f));
        PartDefinition right_wing_open = body.addOrReplaceChild("right_wing_open", CubeListBuilder.create().texOffs(0, 19).mirror().addBox(-5.5f, 0.0f, -1.0f, 6.0f, 1.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)-1.0f, (float)-3.75f, (float)-1.5f, (float)-0.4363f, (float)0.0f, (float)0.0f));
        right_wing_open.addOrReplaceChild("right_wing_outer", CubeListBuilder.create().texOffs(-6, 26).mirror().addBox(-6.0f, 0.0f, 0.0f, 6.0f, 0.0f, 6.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offset((float)-5.5f, (float)0.0f, (float)-1.0f));
        PartDefinition tail = body.addOrReplaceChild("tail", CubeListBuilder.create().texOffs(12, 0).addBox(-1.0f, -1.0f, 1.0f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).texOffs(16, 0).addBox(-1.0f, -1.001f, 3.0f, 2.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-0.75f, (float)0.5f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        tail.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(16, 0).mirror().addBox(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)).mirror(false), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)2.25f, (float)0.0f, (float)-0.5236f, (float)0.0f));
        tail.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(16, 0).addBox(-1.0f, 0.0f, 0.0f, 2.0f, 0.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-1.0f, (float)2.25f, (float)0.0f, (float)0.5236f, (float)0.0f));
        PartDefinition left_leg = root.addOrReplaceChild("left_leg", CubeListBuilder.create().texOffs(2, 3).addBox(-0.5f, -1.0f, 0.0f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)1.0f, (float)1.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        left_leg.addOrReplaceChild("cube_r3", CubeListBuilder.create().texOffs(-1, 3).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition right_leg = root.addOrReplaceChild("right_leg", CubeListBuilder.create().texOffs(2, 3).addBox(-0.5f, -1.0f, 0.0f, 1.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-1.0f, (float)1.0f, (float)1.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        right_leg.addOrReplaceChild("cube_r4", CubeListBuilder.create().texOffs(-1, 3).addBox(-0.5f, 0.0f, -1.0f, 1.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)2.0f, (float)0.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)modelData, (int)32, (int)32);
    }

    @Override
    protected void setAnimations(CrowEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch, float partialTick) {
        if (!entity.isFlying() && !entity.isInWaterOrBubble()) {
            this.animateWalk(CrowAnimations.WALKING, limbSwing, limbSwingAmount, 5.0f, 5.0f);
        }
        this.animate(entity.standingState, CrowAnimations.STANDING, ageInTicks);
        this.animate(entity.swimmingState, CrowAnimations.SWIMMING, ageInTicks);
        this.animate(entity.glidingState, CrowAnimations.GLIDING, ageInTicks);
        this.animate(entity.flappingState, CrowAnimations.FLAPPING, ageInTicks);
    }

    @Override
    protected boolean shouldRenderWings(CrowEntity entity) {
        return super.shouldRenderWings(entity) || entity.isInWaterOrBubble();
    }
}

