/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity;

import aqario.fowlplay.common.config.FowlPlayConfig;
import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.ai.brain.BirdBrain;
import aqario.fowlplay.common.entity.ai.brain.behaviour.CompositeBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.CustomBehaviours;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetAdultWalkTarget;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetBreatheTarget;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetEntityLookTarget;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SetRandomLookTarget;
import aqario.fowlplay.common.entity.ai.brain.behaviour.SlideBehaviours;
import aqario.fowlplay.common.entity.ai.brain.sensor.AttackTargetSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.AttackedSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.AvoidTargetSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyAdultsSensor;
import aqario.fowlplay.common.entity.ai.brain.sensor.NearbyFoodSensor;
import aqario.fowlplay.common.entity.ai.control.BirdAquaticMoveControl;
import aqario.fowlplay.common.entity.ai.navigation.AmphibiousNavigation;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.core.FowlPlayEntityTypes;
import aqario.fowlplay.core.FowlPlayParticleTypes;
import aqario.fowlplay.core.FowlPlaySoundEvents;
import aqario.fowlplay.core.tags.FowlPlayBiomeTags;
import aqario.fowlplay.core.tags.FowlPlayBlockTags;
import aqario.fowlplay.core.tags.FowlPlayEntityTypeTags;
import aqario.fowlplay.core.tags.FowlPlayItemTags;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.OneRandomBehaviour;
import net.tslat.smartbrainlib.api.core.behaviour.custom.attack.AnimatableMeleeAttack;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.BreedWithPartner;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.Idle;
import net.tslat.smartbrainlib.api.core.behaviour.custom.misc.InvalidateMemory;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FollowParent;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.FollowTemptation;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomSwimTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetRandomWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.path.SetWalkTargetToAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.InvalidateAttackTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetAttackTarget;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.PredicateSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.InWaterSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.ItemTemptingSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyPlayersSensor;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class PenguinEntity
extends BirdEntity
implements BirdBrain<PenguinEntity> {
    private static final int SLIDING_TRANSITION_TICKS = 15;
    private static final int STANDING_TRANSITION_TICKS = 20;
    private static final long LAST_POSE_CHANGE_TICKS = 0L;
    public static final EntityDataAccessor<Long> LAST_POSE_TICK = SynchedEntityData.defineId(PenguinEntity.class, (EntityDataSerializer)EntityDataSerializers.LONG);
    private static final int SWIM_PARTICLE_COUNT = 15;
    public final AnimationState slidingState = new AnimationState();
    public final AnimationState slidingTransitionState = new AnimationState();
    public final AnimationState standingTransitionState = new AnimationState();
    public final AnimationState flappingState = new AnimationState();
    public final AnimationState dancingState = new AnimationState();
    private boolean songPlaying;
    @Nullable
    private BlockPos songSource;

    public PenguinEntity(EntityType<? extends PenguinEntity> entityType, Level world) {
        super(entityType, world);
        this.setPathfindingMalus(PathType.WATER_BORDER, 0.0f);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.setPathfindingMalus(PathType.POWDER_SNOW, 0.0f);
        this.setPathfindingMalus(PathType.DANGER_POWDER_SNOW, 0.0f);
        this.lookControl = new SmoothSwimmingLookControl((Mob)this, 85);
    }

    protected float getFlyingSpeed() {
        return this.isInWaterOrBubble() ? this.getSpeed() : super.getFlyingSpeed();
    }

    public float getSpeed() {
        return this.getPose() == Pose.SLIDING ? super.getSpeed() * 1.5f : super.getSpeed();
    }

    @Override
    protected MoveControl createMoveControl() {
        return new BirdAquaticMoveControl(this, 85, 15, 1.0f, 1.0f, true);
    }

    @Override
    public int getMaxHeadXRot() {
        return this.isInWaterOrBubble() ? 1 : super.getMaxHeadXRot();
    }

    @Override
    public int getMaxHeadYRot() {
        return this.isInWaterOrBubble() ? 1 : super.getMaxHeadYRot();
    }

    protected PathNavigation createNavigation(Level world) {
        return new AmphibiousNavigation((Mob)this, this.level());
    }

    @Override
    public SpawnGroupData finalizeSpawn(ServerLevelAccessor level, DifficultyInstance difficulty, MobSpawnType spawnType, @Nullable SpawnGroupData spawnGroupData) {
        this.initLastPoseTick(level.getLevel().getGameTime());
        return super.finalizeSpawn(level, difficulty, spawnType, spawnGroupData);
    }

    @Override
    @Nullable
    public AgeableMob getBreedOffspring(ServerLevel world, AgeableMob entity) {
        return (AgeableMob)FowlPlayEntityTypes.PENGUIN.get().create((Level)world);
    }

    @Override
    public boolean isFood(ItemStack stack) {
        return this.getFood().test(stack);
    }

    @Override
    public Ingredient getFood() {
        return Ingredient.of(FowlPlayItemTags.PENGUIN_FOOD);
    }

    @Override
    public boolean canHunt(LivingEntity target) {
        return target.getType().is(FowlPlayEntityTypeTags.PENGUIN_HUNT_TARGETS);
    }

    @Override
    public boolean shouldAvoid(LivingEntity entity) {
        return entity.getType().is(FowlPlayEntityTypeTags.PENGUIN_AVOIDS);
    }

    public static AttributeSupplier.Builder createPenguinAttributes() {
        return BirdEntity.createBirdAttributes().add(Attributes.MAX_HEALTH, 16.0).add(Attributes.ATTACK_DAMAGE, 1.0).add(Attributes.MOVEMENT_SPEED, (double)0.145f).add(Attributes.WATER_MOVEMENT_EFFICIENCY, 1.0);
    }

    public void setRecordPlayingNearby(BlockPos songPosition, boolean playing) {
        this.songSource = songPosition;
        this.songPlaying = playing;
    }

    @Override
    public void aiStep() {
        if (this.songSource == null || !this.songSource.closerToCenterThan((Position)this.position(), 5.0) || !this.level().getBlockState(this.songSource).is(Blocks.JUKEBOX)) {
            this.songPlaying = false;
            this.songSource = null;
        }
        super.aiStep();
    }

    public boolean isSongPlaying() {
        return this.songPlaying;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(LAST_POSE_TICK, (Object)0L);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag nbt) {
        super.addAdditionalSaveData(nbt);
        nbt.putLong("lastPoseTick", ((Long)this.entityData.get(LAST_POSE_TICK)).longValue());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag nbt) {
        super.readAdditionalSaveData(nbt);
        long l = nbt.getLong("lastPoseTick");
        if (l < 0L) {
            this.setPose(Pose.SLIDING);
        }
        this.setLastPoseTick(l);
    }

    public void onSyncedDataUpdated(List<SynchedEntityData.DataValue<?>> entries) {
        super.onSyncedDataUpdated(entries);
        this.refreshDimensions();
    }

    @Override
    public void tick() {
        if (this.getControllingPassenger() != null && this.isInWaterOrBubble()) {
            this.getControllingPassenger().stopRiding();
        }
        if (this.isInWaterOrBubble() && !this.isSliding()) {
            this.setSliding();
        }
        super.tick();
        if (this.level().isClientSide() && this.isInWaterOrBubble() && this.getDeltaMovement().lengthSqr() > 0.02) {
            this.addSwimParticles();
        }
        if (this.isSwimming()) {
            this.setPose(Pose.SWIMMING);
        } else if (this.isSliding()) {
            this.setPose(Pose.SLIDING);
        } else {
            this.setPose(Pose.STANDING);
        }
    }

    private void addSwimParticles() {
        Vec3 velocity = this.getLookAngle().reverse().scale(0.5);
        for (int i = 0; i < 15; ++i) {
            this.level().addParticle((ParticleOptions)FowlPlayParticleTypes.SMALL_BUBBLE.get(), this.getX() + (double)(this.random.nextFloat() * 0.75f - 0.375f), this.getY() + this.getBoundingBox().getYsize() / 2.0 + (double)(this.random.nextFloat() * 0.75f - 0.375f), this.getZ() + (double)(this.random.nextFloat() * 0.75f - 0.375f), velocity.x, velocity.y, velocity.z);
        }
    }

    @Override
    protected void updateAnimations() {
        this.standingState.animateWhen(this.onGround() && !this.isInWaterOrBubble() && !this.isSliding(), this.tickCount);
        if (this.isInWaterOrBubble()) {
            this.standingState.stop();
            this.swimmingState.startIfStopped(this.tickCount);
        } else {
            this.swimmingState.stop();
        }
        if (this.shouldUpdateSlidingAnimations() && !this.isInWaterOrBubble()) {
            this.standingState.stop();
            if (this.shouldPlaySlidingTransition()) {
                this.slidingTransitionState.startIfStopped(this.tickCount);
                this.slidingState.stop();
            } else {
                this.slidingTransitionState.stop();
                this.slidingState.startIfStopped(this.tickCount);
            }
        } else {
            this.slidingTransitionState.stop();
            this.slidingState.stop();
            this.standingTransitionState.animateWhen(this.isChangingPose() && this.getLastPoseTickDelta() >= 0L, this.tickCount);
        }
        if (this.isSongPlaying() && this.onGround()) {
            this.dancingState.startIfStopped(this.tickCount);
            this.setStanding();
            this.standingState.stop();
        } else {
            this.dancingState.stop();
        }
    }

    public boolean canStartSliding() {
        return !this.isInWaterOrBubble() && !this.isVehicle() && this.onGround() && (this.level().getBlockState(this.blockPosition().below()).is(FowlPlayBlockTags.PENGUINS_SLIDE_ON) || this.level().getBlockState(this.blockPosition()).is(FowlPlayBlockTags.PENGUINS_SLIDE_ON));
    }

    public boolean isSliding() {
        return (Long)this.entityData.get(LAST_POSE_TICK) < 0L;
    }

    public boolean shouldUpdateSlidingAnimations() {
        return this.getLastPoseTickDelta() < 0L != this.isSliding();
    }

    public boolean isChangingPose() {
        long l = this.getLastPoseTickDelta();
        return l < (long)(this.isSliding() ? 15 : 20);
    }

    private boolean shouldPlaySlidingTransition() {
        return this.isSliding() && this.getLastPoseTickDelta() < 15L && this.getLastPoseTickDelta() >= 0L;
    }

    public void startSliding() {
        if (!this.isSliding()) {
            this.setPose(Pose.SLIDING);
            this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
            this.setLastPoseTick(-this.level().getGameTime());
        }
    }

    public void stopSliding() {
        if (this.isSliding()) {
            this.setPose(Pose.STANDING);
            this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
            this.setLastPoseTick(this.level().getGameTime());
        }
    }

    public void setStanding() {
        this.setPose(Pose.STANDING);
        this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
        this.initLastPoseTick(this.level().getGameTime());
    }

    public void setSliding() {
        this.setPose(Pose.SLIDING);
        this.gameEvent((Holder)GameEvent.ENTITY_ACTION);
        this.setLastPoseTick(-Math.max(0L, this.level().getGameTime() - 15L - 1L));
    }

    private void setLastPoseTick(long lastPoseTick) {
        this.entityData.set(LAST_POSE_TICK, (Object)lastPoseTick);
    }

    private void initLastPoseTick(long time) {
        this.setLastPoseTick(Math.max(0L, time - 20L - 1L));
    }

    public long getLastPoseTickDelta() {
        return this.level().getGameTime() - Math.abs((Long)this.entityData.get(LAST_POSE_TICK));
    }

    public void updateSwimming() {
        this.setSwimming(this.isInWaterOrBubble() && !this.isPassenger());
    }

    protected void clampPassengerYaw(Entity entity) {
        entity.setYBodyRot(this.getYRot());
        float f = Mth.wrapDegrees((float)(entity.getYRot() - this.getYRot()));
        float g = Mth.clamp((float)f, (float)-105.0f, (float)105.0f);
        entity.yRotO += g - f;
        entity.setYRot(entity.getYRot() + g - f);
        entity.setYHeadRot(entity.getYRot());
    }

    public void onPassengerTurned(Entity passenger) {
        this.clampPassengerYaw(passenger);
    }

    public Vec3 getDismountLocationForPassenger(LivingEntity passenger) {
        Vec3 vec3d = PenguinEntity.getCollisionHorizontalEscapeVector((double)(this.getBbWidth() * Mth.SQRT_OF_TWO), (double)passenger.getBbWidth(), (float)passenger.getYRot());
        double d = this.getX() + vec3d.x;
        double e = this.getZ() + vec3d.z;
        BlockPos blockPos = new BlockPos((int)d, (int)this.getAttackBoundingBox().maxY, (int)e);
        BlockPos blockPos2 = blockPos.below();
        if (!this.level().isWaterAt(blockPos2)) {
            double g;
            ArrayList list = Lists.newArrayList();
            double f = this.level().getBlockFloorHeight(blockPos);
            if (DismountHelper.isBlockFloorValid((double)f)) {
                list.add(new Vec3(d, (double)blockPos.getY() + f, e));
            }
            if (DismountHelper.isBlockFloorValid((double)(g = this.level().getBlockFloorHeight(blockPos2)))) {
                list.add(new Vec3(d, (double)blockPos2.getY() + g, e));
            }
            for (Pose entityPose : passenger.getDismountPoses()) {
                for (Vec3 vec3d2 : list) {
                    if (!DismountHelper.canDismountTo((CollisionGetter)this.level(), (Vec3)vec3d2, (LivingEntity)passenger, (Pose)entityPose)) continue;
                    passenger.setPose(entityPose);
                    return vec3d2;
                }
            }
        }
        return super.getDismountLocationForPassenger(passenger);
    }

    public float maxUpStep() {
        return this.getPose() == Pose.SLIDING ? 1.1f : super.maxUpStep();
    }

    public float getAgeScale() {
        return this.isBaby() ? 0.62f : 1.0f;
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        EntityDimensions dimensions = super.getDefaultDimensions(pose);
        return pose == Pose.SLIDING || pose == Pose.SWIMMING ? dimensions.scale(1.0f, 0.35f) : dimensions;
    }

    public boolean isPushedByFluid() {
        return false;
    }

    public boolean isPushable() {
        return !this.isVehicle();
    }

    public boolean isReadyToBreed() {
        return !this.isVehicle() && !this.isPassenger() && !this.isBaby() && this.getHealth() >= this.getMaxHealth() && this.isInLove();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean canMate(Animal other) {
        if (other == this) return false;
        if (!(other instanceof PenguinEntity)) return false;
        PenguinEntity penguin = (PenguinEntity)other;
        if (!this.isReadyToBreed()) return false;
        if (!penguin.isReadyToBreed()) return false;
        return true;
    }

    public boolean shouldStepDown() {
        BlockPos pos = this.blockPosition();
        return !this.onGround() && this.fallDistance > 0.0f && this.fallDistance < 0.1f && !this.level().getBlockState(pos.below()).getCollisionShape((BlockGetter)this.level(), pos.below()).isEmpty();
    }

    @Nullable
    public LivingEntity getControllingPassenger() {
        return (LivingEntity)this.getFirstPassenger();
    }

    protected boolean canAddPassenger(Entity passenger) {
        return super.canAddPassenger(passenger) && !this.isUnderWater();
    }

    protected boolean updateInWaterStateAndDoFluidPushing() {
        boolean touchingWater = this.isInWater();
        boolean bl = super.updateInWaterStateAndDoFluidPushing();
        if (touchingWater != this.isInWater()) {
            this.setPose(this.isInWater() ? Pose.SWIMMING : Pose.STANDING);
            this.refreshDimensions();
        }
        return bl;
    }

    public static boolean canSpawnPenguins(EntityType<? extends BirdEntity> type, LevelAccessor world, MobSpawnType spawnReason, BlockPos pos, RandomSource random) {
        return world.getBiome(pos).is(FowlPlayBiomeTags.SPAWNS_PENGUINS) && world.getBlockState(pos.below()).is(FowlPlayBlockTags.PENGUINS_SPAWNABLE_ON);
    }

    protected void tickRidden(Player player, Vec3 input) {
        super.tickRidden(player, input);
        float sidewaysMovement = player.xxa;
        double rotation = 3.0;
        if (Math.abs(sidewaysMovement) == 0.0f) {
            rotation = 0.0;
        }
        this.setRot((float)((double)this.getYRot() + rotation * (double)(sidewaysMovement < 0.0f ? 1 : -1)), this.getXRot());
        player.setYRot((float)((double)player.getYRot() + rotation * (double)(sidewaysMovement < 0.0f ? 1 : -1)) % 360.0f);
        this.yBodyRot = this.yHeadRot = this.getYRot();
        this.yRotO = this.yHeadRot;
    }

    protected Vec3 getRiddenInput(Player player, Vec3 input) {
        float forwardMovement = player.zza * 0.2f;
        if (this.level().getBlockState(this.getBlockPosBelowThatAffectsMyMovement()).is(FowlPlayBlockTags.PENGUINS_SLIDE_ON) || this.getInBlockState().is(FowlPlayBlockTags.PENGUINS_SLIDE_ON)) {
            forwardMovement *= 2.0f;
        }
        return new Vec3(0.0, 0.0, (double)Math.max(forwardMovement, 0.0f));
    }

    protected float getRiddenSpeed(Player player) {
        return (float)this.getAttributeValue(Attributes.MOVEMENT_SPEED);
    }

    public int getMaxAirSupply() {
        return 9600;
    }

    protected int increaseAirSupply(int air) {
        return this.getMaxAirSupply();
    }

    public InteractionResult mobInteract(Player player, InteractionHand hand) {
        boolean bl = this.isFood(player.getItemInHand(hand));
        if (!(bl || this.isVehicle() || player.isSecondaryUseActive() || this.isBaby() || !this.isSliding())) {
            if (!this.level().isClientSide) {
                player.startRiding((Entity)this);
            }
            return InteractionResult.sidedSuccess((boolean)this.level().isClientSide);
        }
        return super.mobInteract(player, hand);
    }

    protected int calculateFallDamage(float fallDistance, float damageMultiplier) {
        if (this.getPose() == Pose.SLIDING) {
            return (super.calculateFallDamage(fallDistance, damageMultiplier) - 3) / 2;
        }
        return super.calculateFallDamage(fallDistance, damageMultiplier);
    }

    @Override
    protected boolean canCall() {
        return !this.isInWaterOrBubble() && super.canCall();
    }

    @Override
    @Nullable
    protected SoundEvent getCallSound() {
        return this.isBaby() ? FowlPlaySoundEvents.ENTITY_PENGUIN_BABY_CALL.get() : FowlPlaySoundEvents.ENTITY_PENGUIN_CALL.get();
    }

    @Override
    protected float getCallVolume() {
        return FowlPlayConfig.getInstance().penguinCallVolume;
    }

    protected SoundEvent getSwimSound() {
        return FowlPlaySoundEvents.ENTITY_PENGUIN_SWIM.get();
    }

    @Override
    protected SoundEvent getHurtSound(DamageSource source) {
        return FowlPlaySoundEvents.ENTITY_PENGUIN_HURT.get();
    }

    protected Brain.Provider<PenguinEntity> brainProvider() {
        return new SmartBrainProvider((LivingEntity)this);
    }

    public List<? extends ExtendedSensor<? extends PenguinEntity>> getSensors() {
        return ObjectArrayList.of((Object[])new PredicateSensor[]{new NearbyLivingEntitySensor(), new NearbyPlayersSensor(), new NearbyFoodSensor(), new NearbyAdultsSensor(), new ItemTemptingSensor().temptedWith((entity, stack) -> this.getFood().test(stack)), new InWaterSensor(), new AttackedSensor(), new AvoidTargetSensor(), new AttackTargetSensor()});
    }

    public BrainActivityGroup<? extends PenguinEntity> getCoreTasks() {
        return BirdBrain.coreActivity(new Behavior[]{new SetBreatheTarget(), new SetAttackTarget(), new LookAtTarget().runFor(entity -> entity.getRandom().nextIntBetweenInclusive(45, 90)), new MoveToWalkTarget()});
    }

    @Override
    public BrainActivityGroup<? extends PenguinEntity> getAvoidTasks() {
        return BirdBrain.avoidActivity(new Behavior[]{CustomBehaviours.setAvoidEntityWalkTarget()});
    }

    public BrainActivityGroup<? extends PenguinEntity> getFightTasks() {
        return BirdBrain.fightActivity(new Behavior[]{new InvalidateAttackTarget(), SlideBehaviours.startSliding(), new SetWalkTargetToAttackTarget().speedMod((entity, target) -> Float.valueOf(1.4f)), new AnimatableMeleeAttack(0), new InvalidateMemory(MemoryModuleType.ATTACK_TARGET).invalidateIf((entity, memory) -> BehaviorUtils.isBreeding((LivingEntity)entity))});
    }

    public BrainActivityGroup<? extends PenguinEntity> getIdleTasks() {
        return BirdBrain.idleActivity(new Behavior[]{new BreedWithPartner(), new FollowParent(), SetEntityLookTarget.create(EntityType.PLAYER), new FollowTemptation(), new SetRandomLookTarget().lookChance(0.02f), new OneRandomBehaviour(new Pair[]{Pair.of((Object)new SetRandomWalkTarget().setRadius(64.0, 32.0), (Object)5), Pair.of((Object)new SetRandomSwimTarget().setRadius(32.0, 16.0), (Object)2)}).startCondition(entity -> entity.isInWaterOrBubble() && !BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.WALK_TARGET)), new OneRandomBehaviour(new Pair[]{Pair.of((Object)new SetRandomWalkTarget().setRadius(24.0, 12.0), (Object)2), Pair.of(SlideBehaviours.toggleSliding(20), (Object)5), Pair.of((Object)new Idle().runFor(entity -> entity.getRandom().nextIntBetweenInclusive(400, 800)), (Object)5), Pair.of(SetAdultWalkTarget.create(Birds.STAY_NEAR_ENTITY_RANGE), (Object)2), Pair.of(CompositeBehaviours.slideToWater(), (Object)6)}).startCondition(entity -> !entity.isInWaterOrBubble() && !BrainUtils.hasMemory((LivingEntity)entity, (MemoryModuleType)MemoryModuleType.WALK_TARGET))});
    }

    @Override
    public BrainActivityGroup<? extends PenguinEntity> getPickupFoodTasks() {
        return BirdBrain.pickupFoodActivity(new Behavior[]{SlideBehaviours.startSliding(), CustomBehaviours.setNearestFoodWalkTarget()});
    }

    @Override
    public BrainActivityGroup<? extends PenguinEntity> getRestTasks() {
        return BirdBrain.restActivity(new Behavior[]{new Idle()});
    }

    protected void customServerAiStep() {
        Brain brain = this.getBrain();
        Activity activity = brain.getActiveNonCoreActivity().orElse(null);
        this.tickBrain((LivingEntity)this);
        if (activity == Activity.FIGHT && brain.getActiveNonCoreActivity().orElse(null) != Activity.FIGHT) {
            brain.setMemoryWithExpiry(MemoryModuleType.HAS_HUNTING_COOLDOWN, (Object)true, 2400L);
        }
        super.customServerAiStep();
    }
}

