/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.entity.ai.control;

import aqario.fowlplay.common.entity.FlyingBirdEntity;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.control.LookControl;

public class BirdLookControl
extends LookControl {
    private final int maxYawDifference;

    public BirdLookControl(Mob entity, int maxYawDifference) {
        super(entity);
        this.maxYawDifference = maxYawDifference;
    }

    public void setLookAt(double x, double y, double z, float yawSpeed, float pitchSpeed) {
        this.wantedX = x;
        this.wantedY = y;
        this.wantedZ = z;
        this.yMaxRotSpeed = yawSpeed;
        this.xMaxRotAngle = pitchSpeed;
        this.lookAtCooldown = Mth.randomBetweenInclusive((RandomSource)this.mob.getRandom(), (int)2, (int)8);
    }

    public void tick() {
        FlyingBirdEntity bird;
        Mob mob = this.mob;
        if (mob instanceof FlyingBirdEntity && (bird = (FlyingBirdEntity)mob).isFlying()) {
            this.tickFlying();
        } else {
            this.tickOnGround();
        }
    }

    private void tickFlying() {
        this.mob.yBodyRot = this.mob.yHeadRot;
    }

    private void tickOnGround() {
        if (this.lookAtCooldown > 0) {
            --this.lookAtCooldown;
            this.getYRotD().ifPresent(yaw -> {
                this.mob.yHeadRot = this.rotateTowards(this.mob.yHeadRot, this.calculateYaw(this.mob.yHeadRot, yaw.floatValue()), this.yMaxRotSpeed);
            });
            this.getXRotD().ifPresent(pitch -> this.mob.setXRot(this.rotateTowards(this.mob.getXRot(), pitch.floatValue(), this.xMaxRotAngle)));
        } else {
            if (this.mob.getNavigation().isDone()) {
                this.mob.setXRot(this.rotateTowards(this.mob.getXRot(), 0.0f, 5.0f));
            }
            this.mob.yHeadRot = this.rotateTowards(this.mob.yHeadRot, this.mob.yBodyRot, this.yMaxRotSpeed);
        }
        float yawDif = Mth.wrapDegrees((float)(this.mob.yHeadRot - this.mob.yBodyRot));
        if (yawDif < (float)(-this.maxYawDifference)) {
            this.mob.yBodyRot -= 4.0f;
        } else if (yawDif > (float)this.maxYawDifference) {
            this.mob.yBodyRot += 4.0f;
        }
    }

    private float calculateYaw(float curYaw, float targetYaw) {
        float diffMinus;
        float plus60 = Mth.wrapDegrees((float)(targetYaw + 60.0f));
        float minus60 = Mth.wrapDegrees((float)(targetYaw - 60.0f));
        float diffPlus = Math.abs(Mth.wrapDegrees((float)(plus60 - curYaw)));
        return diffPlus < (diffMinus = Math.abs(Mth.wrapDegrees((float)(minus60 - curYaw)))) ? plus60 : minus60;
    }
}

