/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.item;

import aqario.fowlplay.common.entity.ScarecrowEntity;
import aqario.fowlplay.core.FowlPlayEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class ScarecrowItem
extends Item {
    public ScarecrowItem(Item.Properties settings) {
        super(settings);
    }

    public InteractionResult useOn(UseOnContext usageContext) {
        Direction direction = usageContext.getClickedFace();
        if (direction == Direction.DOWN) {
            return InteractionResult.FAIL;
        }
        Level world = usageContext.getLevel();
        BlockPlaceContext placementContext = new BlockPlaceContext(usageContext);
        BlockPos blockPos = placementContext.getClickedPos();
        ItemStack itemStack = usageContext.getItemInHand();
        Vec3 vec3d = Vec3.atBottomCenterOf((Vec3i)blockPos);
        AABB box = FowlPlayEntityTypes.SCARECROW.get().getDimensions().makeBoundingBox(vec3d.x(), vec3d.y(), vec3d.z());
        if (!world.noCollision(null, box) || !world.getEntities(null, box).isEmpty()) {
            return InteractionResult.FAIL;
        }
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            ScarecrowEntity scarecrow = (ScarecrowEntity)FowlPlayEntityTypes.SCARECROW.get().create(serverWorld, null, blockPos, MobSpawnType.SPAWN_EGG, true, true);
            if (scarecrow == null) {
                return InteractionResult.FAIL;
            }
            float yaw = (float)Mth.floor((float)((Mth.wrapDegrees((float)(usageContext.getRotation() - 180.0f)) + 22.5f) / 45.0f)) * 45.0f;
            scarecrow.moveTo(scarecrow.getX(), scarecrow.getY(), scarecrow.getZ(), yaw, 0.0f);
            serverWorld.addFreshEntityWithPassengers((Entity)scarecrow);
            world.playSound(null, scarecrow.getX(), scarecrow.getY(), scarecrow.getZ(), scarecrow.getPlaceSound(), SoundSource.BLOCKS, 0.75f, 0.8f);
            scarecrow.gameEvent((Holder)GameEvent.ENTITY_PLACE, (Entity)usageContext.getPlayer());
        }
        itemStack.shrink(1);
        return InteractionResult.sidedSuccess((boolean)world.isClientSide());
    }
}

