/*
 * Decompiled with CFR 0.152.
 */
package aqario.fowlplay.common.network;

import aqario.fowlplay.client.FowlPlayClient;
import aqario.fowlplay.common.entity.BirdEntity;
import aqario.fowlplay.common.entity.FlyingBirdEntity;
import aqario.fowlplay.common.entity.TrustingBirdEntity;
import aqario.fowlplay.common.network.s2c.BirdDebugPayload;
import aqario.fowlplay.common.util.Birds;
import aqario.fowlplay.core.FowlPlay;
import com.google.common.collect.Lists;
import dev.architectury.networking.NetworkManager;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.DebugEntityNameGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Nameable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.ExpirableValue;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.level.pathfinder.Path;
import net.tslat.smartbrainlib.util.BrainUtils;
import org.jetbrains.annotations.Nullable;

public class FowlPlayDebugPackets {
    public static void sendBirdData(BirdEntity bird) {
        FlyingBirdEntity flyingBird;
        boolean flying;
        if (!FowlPlay.isDebugUtilsLoaded() || bird.level().isClientSide() || !FowlPlayClient.DEBUG_BIRD) {
            return;
        }
        Brain brain = bird.getBrain();
        String name = DebugEntityNameGenerator.getEntityName((Entity)bird);
        String inventory = "";
        Path path = null;
        boolean bl = flying = bird instanceof FlyingBirdEntity && (flyingBird = (FlyingBirdEntity)bird).isFlying();
        if (bird instanceof InventoryCarrier) {
            InventoryCarrier inventoryOwner = (InventoryCarrier)bird;
            String string = inventory = inventoryOwner.getInventory().isEmpty() ? "" : inventoryOwner.getInventory().toString();
        }
        if (BrainUtils.hasMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.PATH)) {
            path = (Path)BrainUtils.getMemory((Brain)brain, (MemoryModuleType)MemoryModuleType.PATH);
        }
        ArrayList<String> trusting = new ArrayList<String>();
        if (bird instanceof TrustingBirdEntity) {
            TrustingBirdEntity trustingBird = (TrustingBirdEntity)bird;
            trustingBird.getTrustedUuids().forEach(uuid -> {
                Player player = bird.level().getPlayerByUUID(uuid);
                if (player != null) {
                    trusting.add(player.getName().getString());
                } else {
                    trusting.add(uuid.toString());
                }
            });
        }
        List<String> activities = brain.getActiveActivities().stream().map(Activity::getName).toList();
        List<String> behaviors = brain.getRunningBehaviors().stream().map(BehaviorControl::debugString).toList();
        List<String> memories = FowlPlayDebugPackets.getMemoryDescriptions((LivingEntity)bird, bird.level().getGameTime());
        String schedule = Optional.ofNullable(BuiltInRegistries.SCHEDULE.getKey((Object)brain.getSchedule())).map(ResourceLocation::getPath).orElse(null);
        Set<BlockPos> pois = Set.of();
        Set<BlockPos> potentialPois = Set.of();
        BirdDebugPayload.BirdData data = new BirdDebugPayload.BirdData(bird.getUUID(), bird.getId(), name, bird.getMoveControl().getClass().getSimpleName(), bird.getNavigation().getClass().getSimpleName(), bird.getHealth(), bird.getMaxHealth(), bird.position(), inventory, path, trusting, flying, bird.isAmbient(), Birds.isPerched(bird), activities, behaviors, memories, schedule, pois, potentialPois);
        BirdDebugPayload payload = new BirdDebugPayload(data);
        FowlPlayDebugPackets.sendToAll((ServerLevel)bird.level(), payload);
    }

    private static List<String> getMemoryDescriptions(LivingEntity entity, long gameTime) {
        Map map = entity.getBrain().getMemories();
        ArrayList list = Lists.newArrayList();
        for (Map.Entry entry : map.entrySet()) {
            Object value;
            MemoryModuleType memoryModuleType = (MemoryModuleType)entry.getKey();
            Optional optional = (Optional)entry.getValue();
            if (optional.isPresent()) {
                ExpirableValue expirableValue = (ExpirableValue)optional.get();
                Object object = expirableValue.getValue();
                if (memoryModuleType == MemoryModuleType.HEARD_BELL_TIME) {
                    long l = gameTime - (Long)object;
                    value = l + " ticks ago";
                } else if (expirableValue.canExpire()) {
                    String desc = FowlPlayDebugPackets.getMemoryValueDescription((ServerLevel)entity.level(), object);
                    value = desc + " (ttl: " + expirableValue.getTimeToLive() + ")";
                } else {
                    value = FowlPlayDebugPackets.getMemoryValueDescription((ServerLevel)entity.level(), object);
                }
            } else {
                value = "-";
            }
            String memory = BuiltInRegistries.MEMORY_MODULE_TYPE.getKey((Object)memoryModuleType).getPath();
            list.add(memory + ": " + (String)value);
        }
        list.sort(String::compareTo);
        return list;
    }

    private static String getMemoryValueDescription(ServerLevel world, @Nullable Object object) {
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{UUID.class, LivingEntity.class, Nameable.class, WalkTarget.class, EntityTracker.class, GlobalPos.class, BlockPosTracker.class, DamageSource.class, Collection.class, NearestVisibleLivingEntities.class}, (Object)object2, n)) {
            case -1: {
                return "-";
            }
            case 0: {
                UUID uuid = (UUID)object2;
                return FowlPlayDebugPackets.getMemoryValueDescription(world, world.getEntity(uuid));
            }
            case 1: {
                LivingEntity entity = (LivingEntity)object2;
                return DebugEntityNameGenerator.getEntityName((Entity)entity);
            }
            case 2: {
                Nameable nameable = (Nameable)object2;
                return nameable.getName().getString();
            }
            case 3: {
                WalkTarget walkTarget = (WalkTarget)object2;
                return FowlPlayDebugPackets.getMemoryValueDescription(world, walkTarget.getTarget());
            }
            case 4: {
                EntityTracker entityLookTarget = (EntityTracker)object2;
                return FowlPlayDebugPackets.getMemoryValueDescription(world, entityLookTarget.getEntity());
            }
            case 5: {
                GlobalPos globalPos = (GlobalPos)object2;
                return FowlPlayDebugPackets.getMemoryValueDescription(world, globalPos.pos());
            }
            case 6: {
                BlockPosTracker blockPosLookTarget = (BlockPosTracker)object2;
                return FowlPlayDebugPackets.getMemoryValueDescription(world, blockPosLookTarget.currentBlockPosition());
            }
            case 7: {
                DamageSource damageSource = (DamageSource)object2;
                Entity entity = damageSource.getEntity();
                return entity == null ? object.toString() : FowlPlayDebugPackets.getMemoryValueDescription(world, entity);
            }
            case 8: {
                Collection iterable = (Collection)object2;
                ArrayList list = Lists.newArrayList();
                iterable.forEach(o -> list.add(FowlPlayDebugPackets.getMemoryValueDescription(world, o)));
                return ((Object)list).toString();
            }
            case 9: {
                NearestVisibleLivingEntities cache = (NearestVisibleLivingEntities)object2;
                ArrayList list = Lists.newArrayList();
                cache.nearbyEntities.forEach(o -> list.add(FowlPlayDebugPackets.getMemoryValueDescription(world, o)));
                return ((Object)list).toString();
            }
        }
        return object.toString();
    }

    private static void sendToAll(ServerLevel world, CustomPacketPayload payload) {
        NetworkManager.sendToPlayers((Iterable)world.players(), (CustomPacketPayload)payload);
    }
}

