/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.util;

import net.minecraft.world.entity.player.Player;

public class XpHelper {
    private static final int RATIO = 20;

    private XpHelper() {
    }

    public static float liquidToExperience(int liquid) {
        return (float)liquid / 20.0f;
    }

    public static int experienceToLiquid(float xp) {
        return (int)(xp * 20.0f);
    }

    public static int getExperienceForLevel(int level) {
        if (level == 0) {
            return 0;
        }
        if (level > 0 && level < 16) {
            return level * (12 + level * 2) / 2;
        }
        if (level > 15 && level < 31) {
            return (level - 15) * (69 + (level - 15) * 5) / 2 + 315;
        }
        return (int)Math.min(Integer.MAX_VALUE, ((long)level - 30L) * (215L + (long)(level - 30) * 9L) / 2L + 1395L);
    }

    public static int getExperienceLimitOnLevel(int level) {
        if (level >= 30) {
            return 112 + (level - 30) * 9;
        }
        if (level >= 15) {
            return 37 + (level - 15) * 5;
        }
        return 7 + level * 2;
    }

    public static int getLevelForExperience(int experience) {
        int i = 0;
        int xp = XpHelper.getExperienceForLevel(i);
        int maxXp = 0;
        while (xp <= experience && (xp = XpHelper.getExperienceForLevel(++i)) > maxXp) {
            maxXp = xp;
        }
        return i - 1;
    }

    public static double getLevelsForExperience(int experience) {
        int baseLevel = XpHelper.getLevelForExperience(experience);
        int remainingExperience = experience - XpHelper.getExperienceForLevel(baseLevel);
        return (double)baseLevel + (double)remainingExperience / (double)XpHelper.getExperienceLimitOnLevel(baseLevel);
    }

    public static int getPlayerTotalExperience(Player player) {
        int experienceForLevel = XpHelper.getExperienceForLevel(player.experienceLevel);
        return (int)Math.min(Integer.MAX_VALUE, (long)experienceForLevel + (long)(player.experienceProgress * (float)player.getXpNeededForNextLevel()));
    }
}

