/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.logic.entityblocking;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;
import net.xalcon.torchmaster.Torchmaster;
import net.xalcon.torchmaster.logic.entityblocking.IBlockingLightManager;
import net.xalcon.torchmaster.logic.entityblocking.IEntityBlockingLight;
import net.xalcon.torchmaster.logic.entityblocking.LightSerializerRegistry;
import net.xalcon.torchmaster.logic.entityblocking.TorchInfo;

public class FilteredLightManager
extends SavedData
implements IBlockingLightManager {
    private final Map<String, IEntityBlockingLight> lights = new HashMap<String, IEntityBlockingLight>();
    public static final SavedData.Factory<FilteredLightManager> Factory = new SavedData.Factory(FilteredLightManager::new, FilteredLightManager::load, null);

    @Override
    public boolean shouldBlockEntityType(EntityType<?> entityType, Level level, Vec3 pos, MobSpawnType spawnType) {
        for (IEntityBlockingLight light : this.lights.values()) {
            if (!light.shouldBlockEntityType(entityType, level, pos, spawnType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean shouldBlockVillageZombieRaid(Vec3 pos) {
        for (IEntityBlockingLight light : this.lights.values()) {
            if (!light.shouldBlockVillageZombieRaid(pos)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void registerLight(String lightKey, IEntityBlockingLight light) {
        this.lights.put(lightKey, light);
        this.setDirty();
    }

    @Override
    public void unregisterLight(String lightKey) {
        this.lights.remove(lightKey);
        this.setDirty();
    }

    @Override
    public Optional<IEntityBlockingLight> getLight(String lightKey) {
        IEntityBlockingLight light = this.lights.get(lightKey);
        if (light == null) {
            return Optional.empty();
        }
        return Optional.of(light);
    }

    @Override
    public void onGlobalTick(Level level) {
        for (IEntityBlockingLight light : this.lights.values()) {
            light.cleanupCheck(level);
        }
    }

    @Override
    public TorchInfo[] getEntries() {
        return new TorchInfo[0];
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        ListTag list = new ListTag();
        for (Map.Entry<String, IEntityBlockingLight> pair : this.lights.entrySet()) {
            String lightKey = pair.getKey();
            IEntityBlockingLight light = pair.getValue();
            String serializerType = light.getLightSerializerType();
            LightSerializerRegistry.getLightSerializer(serializerType).ifPresentOrElse(serializer -> {
                CompoundTag tag = serializer.serializeLight(light);
                tag.putString("_type", serializerType);
                tag.putString("_key", lightKey);
                list.add((Object)tag);
            }, () -> Torchmaster.LOG.error("Unable to save light {}, data is lost", (Object)light.getPos()));
        }
        CompoundTag tag = new CompoundTag();
        tag.put("lights", (Tag)list);
        return tag;
    }

    private static FilteredLightManager load(CompoundTag tag, HolderLookup.Provider provider) {
        ListTag lightsList = tag.getList("lights", 10);
        FilteredLightManager mgr = new FilteredLightManager();
        mgr.lights.clear();
        for (int i = 0; i < lightsList.size(); ++i) {
            CompoundTag lightNbt = lightsList.getCompound(i);
            String lightKey = lightNbt.getString("_key");
            String serializerType = lightNbt.getString("_type");
            LightSerializerRegistry.getLightSerializer(serializerType).ifPresentOrElse(serializer -> serializer.deserializeLight(lightNbt).ifPresentOrElse(l -> mgr.lights.put(lightKey, (IEntityBlockingLight)l), () -> Torchmaster.LOG.error("Unable to load light data from nbt for {} - {}, deserialization failed, data is lost", (Object)lightKey, (Object)serializerType)), () -> Torchmaster.LOG.error("Unable to load light data from nbt for {} - {}. Serializer not found, data is lost", (Object)lightKey, (Object)serializerType));
        }
        return mgr;
    }
}

