/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.logic.entityblocking.dreadlamp;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.xalcon.torchmaster.logic.entityblocking.IEntityBlockingLight;
import net.xalcon.torchmaster.logic.entityblocking.ILightSerializer;
import net.xalcon.torchmaster.logic.entityblocking.dreadlamp.DreadLampEntityBlockingLight;

public class DreadLampSerializer
implements ILightSerializer {
    public static final String SERIALIZER_KEY = "dreadlamp";
    public static final DreadLampSerializer INSTANCE = new DreadLampSerializer();

    private DreadLampSerializer() {
    }

    @Override
    public CompoundTag serializeLight(IEntityBlockingLight light) {
        if (light == null) {
            throw new IllegalArgumentException("Unable to serialize null");
        }
        if (!(light instanceof DreadLampEntityBlockingLight)) {
            throw new IllegalArgumentException("Unable to serialize '" + light.getClass().getCanonicalName() + "', expected '" + DreadLampEntityBlockingLight.class.getCanonicalName() + "'");
        }
        DreadLampEntityBlockingLight dreadLampLight = (DreadLampEntityBlockingLight)light;
        CompoundTag nbt = new CompoundTag();
        nbt.put("pos", NbtUtils.writeBlockPos((BlockPos)dreadLampLight.getPos()));
        return nbt;
    }

    @Override
    public Optional<IEntityBlockingLight> deserializeLight(CompoundTag nbt) {
        Optional pos = NbtUtils.readBlockPos((CompoundTag)nbt, (String)"pos");
        return pos.map(DreadLampEntityBlockingLight::new);
    }

    @Override
    public String getSerializerKey() {
        return SERIALIZER_KEY;
    }
}

